//
//  ViewController.m
//  AdgoDemo
//
//  Created by xiezuan on 2020/12/20.
//

#import "ViewController.h"
#import "BannerViewController.h"
#import "InterstitialViewController.h"
#import "RewardedViewController.h"
#import "SplashViewController.h"
#import "FeedViewController.h"
#import "ContentViewController.h"

#import "Common.h"
#import <AdSupport/AdSupport.h>
#import <AdSupport/ASIdentifierManager.h>
#import <AppTrackingTransparency/AppTrackingTransparency.h>

#import <UNAD/UNAD.h>
#import "QWechatManager.h"
#import <Masonry/Masonry.h>
#import "GoogleMobileAdsConsentManager.h"


@interface ViewController ()<UITableViewDelegate,UITableViewDataSource,UNADSplashDelegate>

@property(nonatomic, copy) NSString *idfa;
@property(nonatomic, strong) UNADGameViewController *gameViewController;

@property(nonatomic,strong) UITableView *tableView;
@property(nonatomic, strong) UISegmentedControl *segment;


@property (nonatomic, strong) UNADSplash *splash;
@property(nonatomic, assign) BOOL isFirstLoad;
@property(nonatomic, assign) BOOL isChina;


@end

@implementation ViewController

- (void)viewDidAppear:(BOOL)animated{
    
    [self getIDFA];
}





- (UIEdgeInsets)safeAreaInsets {
    if (@available(iOS 11.0, *)) {
        UIWindow *mainWindow = [[[UIApplication sharedApplication] delegate] window];
        return mainWindow.safeAreaInsets;
    }else{
        return UIEdgeInsetsMake(0, 0, 0, 0);
    }
}


- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    

    
}

- (void)viewDidLoad {
    [super viewDidLoad];
   // self.title = @"UNAD";
    self.view.backgroundColor = [UIColor colorWithRed:242.0/255 green:242.0/255 blue:242.0/255 alpha:1];
    // Do any additional setup after loading the view.
    self.edgesForExtendedLayout = UIRectEdgeNone;
    

    
    UISegmentedControl *segment = [[UISegmentedControl alloc]initWithFrame:CGRectZero];
    segment.selectedSegmentIndex = 0;
    segment=[[UISegmentedControl alloc]initWithItems:@[@"国内",@"海外"]];
    segment.tintColor=[UIColor redColor];
    segment.selectedSegmentIndex=0;
    [segment addTarget:self action:@selector(changeIndex:) forControlEvents:UIControlEventValueChanged];

    self.segment = segment;
    [self.view addSubview:segment];
    
  
    self.tableView = [UITableView new];
//    self.tableView.separatorColor = [UIColor colorWithRed:0.31 green:0.31 blue:0.31 alpha:1];
    self.tableView.rowHeight = 50;
    self.tableView.sectionHeaderHeight = 30;
    
    self.tableView.dataSource = self;
    self.tableView.delegate = self;
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.tableFooterView = [UIView new];
    //self.title = @"Ads";
    self.tableView.accessibilityLabel = @"Ad Table View";
    
    [self.view addSubview:self.tableView];
    self.tableView.frame  = CGRectMake(0, 0, SC_Width, SC_Height);
    self.tableView.tableFooterView = [UIView new];
    
    
    [segment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(10);
        make.centerX.equalTo(self.view);
        make.width.mas_equalTo(160);
    }];
    
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.equalTo(self.view);
        make.top.mas_equalTo(segment.mas_bottom).offset(10);
    }];
    
    
    [self getIDFA];
    
    [self.tableView reloadData];
    
    
   
    [self loadAndShowConsentFormIfRequired];
  
    
   
        
}

//如果需要的话显示征求用户意见过话框
- (void)loadAndShowConsentFormIfRequired{
    [[GoogleMobileAdsConsentManager sharedInstance] gatherConsentFromConsentPresentationViewController:self
                                                                              consentGatheringComplete:^(NSError * _Nullable error) {
        
        //1.欧盟地区会窗口显示，等用户操作完，非欧盟地区不会弹出窗口，国内地区会请求超时,然后执行后面的代码
        if (@available(iOS 14, *)) {
            // iOS14及以上版本需要先请求权限
            [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
            }];
        }
        
    }];    
}



- (void)getIDFA {
    
    return;
    if (@available(iOS 14, *)) {
        // iOS14及以上版本需要先请求权限
        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
            // 获取到权限后，依然使用老方法获取idfa
            if (status == ATTrackingManagerAuthorizationStatusAuthorized) {
                
                //用户同意获取跟踪权限后，再弹出欧盟的隐私权限弹窗
              //  [self loadAndShowConsentFormIfRequired];
                
                
                
                NSString *idfa = [[ASIdentifierManager sharedManager].advertisingIdentifier UUIDString];
                NSLog(@"%@",idfa);
                self.idfa = idfa;
                
                
                dispatch_async(dispatch_get_main_queue(), ^(){
                    [self.tableView reloadData];
                    
                });
            
            } else {
                NSLog(@"请在设置-隐私-跟踪中允许App请求跟踪");
            }
        }];
    } else {
        // iOS14以下版本依然使用老方法
        // 判断在设置-隐私里用户是否打开了广告跟踪
        if ([[ASIdentifierManager sharedManager] isAdvertisingTrackingEnabled]) {
            NSString *idfa = [[ASIdentifierManager sharedManager].advertisingIdentifier UUIDString];
            NSLog(@"%@",idfa);
            self.idfa = idfa;
            
            [self.tableView reloadData];
        } else {
            NSLog(@"请在设置-隐私-广告中打开广告跟踪功能");
        }
    }
}




-(void)changeIndex:(UISegmentedControl *)segment{
    NSInteger index=segment.selectedSegmentIndex;
    if(index == 0) {
        [UNAD setArea:UNADAreaCN];
    }else{
        [UNAD setArea:UNADAreaOther];
    }
}







#pragma mark - Table view data source


#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section{
    if(section == 0) {
        return 20;
    }else{
        return 1;
    }
}



- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if(section == 0) {
        return  1;
    }else{
        return 5;
    }
    
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
    }
    
    if(indexPath.section == 0){
        cell.textLabel.text = @"IDFA";
        
        if(self.idfa.length == 0) {
            cell.detailTextLabel. text = @"请在设置-隐私-广告中打开广告跟踪功能";
        }else {
            cell.detailTextLabel. text = self.idfa;
        }
    
    }else{
        
        cell.detailTextLabel. text = @"";
        switch (indexPath.row) {
            case 0:
                cell.textLabel.text = @"横幅";
                break;
            case 1:
                cell.textLabel.text = @"信息流";
                break;
            case 2:
                cell.textLabel.text = @"插屏";
                break;
            case 3:
                cell.textLabel.text = @"激励视频";
                break;
            case 4:
                cell.textLabel.text = @"开屏";
                break;
            case 5:
                cell.textLabel.text = @"内容";
                break;
            default:
                break;
        }
    }
    
   

    cell.textLabel.textColor = [UIColor colorWithRed:0.42 green:0.66 blue:0.85 alpha:1];
    cell.detailTextLabel.textColor = [UIColor colorWithRed:0.86 green:0.86 blue:0.86 alpha:1];
    
    return cell;
}





- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if(indexPath.section == 0) {
        if(_idfa.length >0) {
            UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
            pasteboard.string = self.idfa;
            
            UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"提示" message:@"IDFA已复制" preferredStyle:UIAlertControllerStyleAlert];
            UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault
                                                                  handler:nil];
          
            [alert addAction:defaultAction];
            [self presentViewController:alert animated:YES completion:nil];
        }else{
//            UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"提示" message:@"请在设置-隐私-广告中打开广告跟踪功能" preferredStyle:UIAlertControllerStyleAlert];
//             [self presentViewController:alert animated:YES completion:nil];
//
//              UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault
//                                                                    handler:nil];
//
//              [alert addAction:defaultAction];
//
//              [self presentViewController:alert animated:YES completion:nil];

            
            
        }
        
        
    }else{
        UIViewController *detailViewController = nil;
        switch (indexPath.row) {
          
            case 0:{
                BannerViewController *detailViewController;
                detailViewController = [[BannerViewController alloc]init];
                detailViewController.isCN = (self.segment.selectedSegmentIndex==0)?YES:NO;
                detailViewController.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:detailViewController animated:YES];
            }
               
                break;
            case 1:{
                FeedViewController *detailViewController;
                detailViewController = [[FeedViewController alloc]init];
                detailViewController.isCN = (self.segment.selectedSegmentIndex==0)?YES:NO;
                detailViewController.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:detailViewController animated:YES];
            }
                
                break;
            case 2:{
                InterstitialViewController *detailViewController;
                detailViewController = [[InterstitialViewController alloc]initWithNibName:@"InterstitialViewController" bundle:nil];
                detailViewController.isCN = (self.segment.selectedSegmentIndex==0)?YES:NO;
                detailViewController.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:detailViewController animated:YES];
            }
               
                break;
            case 3:{
                RewardedViewController *detailViewController;
                detailViewController = [[RewardedViewController alloc]initWithNibName:@"RewardedViewController" bundle:nil];
                detailViewController.isCN = (self.segment.selectedSegmentIndex==0)?YES:NO;
                detailViewController.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:detailViewController animated:YES];
            }
               
                break;
            case 4:{
                SplashViewController *detailViewController;
                detailViewController = [[SplashViewController alloc]initWithNibName:@"SplashViewController" bundle:nil];
                detailViewController.isCN = (self.segment.selectedSegmentIndex==0)?YES:NO;
                detailViewController.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:detailViewController animated:YES];
            }
                
                break;
            case 5: {
//                self.gameViewController =  [[UNADGameViewController alloc]initWithUnitID:UNAD_TEST_UNIT_ID_GAME_CN_HUAYUAN];
//
//                __weak __typeof(self)weakSelf = self;
//                self.gameViewController.wxLoginBlock = ^{
//                    [weakSelf.gameViewController testWxLoginCallBack:@"8821"];
//                };
//
//                self.gameViewController.modalPresentationStyle = UIModalPresentationFullScreen;
//                [self presentViewController:self.gameViewController animated:YES completion:nil];
                
                
                ContentViewController *detailViewController;
                detailViewController = [ContentViewController new];
                detailViewController.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:detailViewController animated:YES];

          
                
                
            }
                break;
                
                
            default:
                break;
       
        }
        
    }
    
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}



@end
