//
//  SplashViewController.m
//  TestAdgo
//
//  Created by xiezuan on 2020/2/10.
//

#import "SplashViewController.h"
#import <UNAD/UNAD.h>

@interface SplashViewController ()<UNADSplashDelegate>

@property (nonatomic, strong) UNADSplash *adgoSplash;


@end

@implementation SplashViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"开屏";
    
    NSString *unitID = @"";
    if(self.isCN){
        unitID = UNAD_TEST_UNIT_ID_SPLASH_CN;
    }else {
        unitID = UNAD_TEST_UNIT_ID_SPLASH;
    }
    

    self.adgoSplash = [[UNADSplash alloc]initWithUnitID:unitID
                                               lifeTime:10
                                             fetchDelay:10];
    UIImage *splashImage = [UIImage imageNamed:@"launchbg"];
    self.adgoSplash.backgroundImage = splashImage;
    //self.adgoSplash.logoImage = [UIImage imageNamed:@"applogo"];
    self.adgoSplash.delegate = self;
    // Do any additional setup after loading the view.
}


- (IBAction)loadAndShow:(id)sender {
    _statusLabel.text = @"加载中...";
    [self.adgoSplash loadAndShow:self.navigationController];
    
}



- (IBAction)loadAd:(id)sender {
   
    _statusLabel.text = @"加载中...";
    [self.adgoSplash loadAd];
}


- (IBAction)showAd:(id)sender {
    
    
    if([self.adgoSplash isAdValid]) {
        [self.adgoSplash showAd:self.navigationController];
        _statusLabel.text = @"展示广告";
    }else{
        _statusLabel.text = @"广告没有准备好";
    }
    
   
}






#pragma mark- UNADSplashDelegate

//- (UIView *)splashBottomView
//{
//    
////    return nil;
//    CGFloat logoHeight = 60;
//    UIView *bottomView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, [[UIScreen mainScreen] bounds].size.width, logoHeight)];
//    bottomView.backgroundColor = [UIColor whiteColor];
//    UIImageView *logo = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"SplashLogo"]];
//    logo.accessibilityIdentifier = @"splash_logo";
//    logo.frame = CGRectMake(0, 0, 311, 47);
//    logo.center = bottomView.center;
//    [bottomView addSubview:logo];
//    return  bottomView;
//    
//}



- (void)splashAdDidLoad:(UNADSplash *)splash {
    _statusLabel.text = @"广告已加载";
}

/**
 开屏展现
 */
- (void)splashDidPresentScreen:(UNADSplash *)splash
{
    NSLog(@"开屏展现广告");
    _statusLabel.text = @"开屏展现广告";
}


/**
 开屏广告曝光回调
 */


- (void)splashDidClick:(UNADSplash *)splash {
    NSLog(@"点击了广告");
    _statusLabel.text = @"点击了广告";
}

/**
 开屏消失
 */
- (void)splashDidDismissScreen:(UNADSplash *)splash;
{
    _statusLabel.text = @"开屏消失";
    NSLog(@"开屏消失");
}

/**
 开屏请求失败
 */
- (void)splash:(UNADSplash *)splash didFailWithError:(NSError *)error;
{
    
    _statusLabel.text = @"广告请求失败";
    NSLog(@"广告请求失败:%@",error);
}




@end
