//
//  ViewController.m
//  AdgoDemo
//
//  Created by xiezuan on 2020/12/20.
//

#import "SettingViewController.h"
#import "GoogleMobileAdsConsentManager.h"
#import <Masonry/Masonry.h>
#import "Common.h"



@interface SettingViewController ()<UITableViewDelegate,UITableViewDataSource>



@property(nonatomic,strong) UITableView *tableView;



@end

@implementation SettingViewController

- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    [self.tableView reloadData];
}

- (UIEdgeInsets)safeAreaInsets {
    if (@available(iOS 11.0, *)) {
        UIWindow *mainWindow = [[[UIApplication sharedApplication] delegate] window];
        return mainWindow.safeAreaInsets;
    }else{
        return UIEdgeInsetsMake(0, 0, 0, 0);
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
   // self.title = @"UNAD";
    self.view.backgroundColor = [UIColor colorWithRed:242.0/255 green:242.0/255 blue:242.0/255 alpha:1];
    // Do any additional setup after loading the view.
    self.edgesForExtendedLayout = UIRectEdgeNone;
    
    self.tableView = [UITableView new];
//    self.tableView.separatorColor = [UIColor colorWithRed:0.31 green:0.31 blue:0.31 alpha:1];
    self.tableView.rowHeight = 50;
    self.tableView.sectionHeaderHeight = 30;
    
    self.tableView.dataSource = self;
    self.tableView.delegate = self;
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.tableFooterView = [UIView new];
    //self.title = @"Ads";
    self.tableView.accessibilityLabel = @"Ad Table View";
    
    [self.view addSubview:self.tableView];
    self.tableView.frame  = CGRectMake(0, 0, SC_Width, SC_Height);
    self.tableView.tableFooterView = [UIView new];
    

    
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];
    
    
    [self.tableView reloadData];
    
    
   
  
    
   
        
}

//如果需要的话显示征求用户意见过话框
- (void)loadAndShowConsentFormIfRequired{
    [[GoogleMobileAdsConsentManager sharedInstance] gatherConsentFromConsentPresentationViewController:self
                                                                              consentGatheringComplete:^(NSError * _Nullable error) {
        
    }];    
}


- (void)showPrivacyForm {
    [GoogleMobileAdsConsentManager.sharedInstance
        presentPrivacyOptionsFormFromViewController:self
                                  completionHandler:^(NSError *_Nullable formError) {
                                    if (formError) {
                                        //错误，不能显示
                                    }
    }];
}


#pragma mark - Table view data source


#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section{
   
    return 1;
    
}



- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{

    if(GoogleMobileAdsConsentManager.sharedInstance.isPrivacyOptionsRequired){
        //需要显示隐私按钮，让用户可以重新选择
        return 3;
    }else{
        //不需要显示
        return 2;
    }
    
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
    }
    

        
        cell.detailTextLabel. text = @"";
        switch (indexPath.row) {
            case 0:
                cell.textLabel.text = @"我的信息";
                break;
            case 1:
                cell.textLabel.text = @"关于";
                break;
            case 2:
                cell.textLabel.text = @"Privacy Settings";
                break;
            default:
                break;
        }
 
    
   

    cell.textLabel.textColor = [UIColor colorWithRed:0.42 green:0.66 blue:0.85 alpha:1];
    cell.detailTextLabel.textColor = [UIColor colorWithRed:0.86 green:0.86 blue:0.86 alpha:1];
    
    return cell;
}





- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if(indexPath.row == 2) {
        [self showPrivacyForm];
    }
     
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}





@end
