//
//  RewardedViewController.m
//  TestAdgo
//
//  Created by xiezuan on 2020/3/1.
//

#import "RewardedViewController.h"
#import <UNAD/UNAD.h>



@interface RewardedViewController ()<UNADRewardedAdDelegate>

@property(nonatomic, strong) UNADRewardedAd *rewardedAd;

@end

@implementation RewardedViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"激励视频";
 
    // Do any additional setup after loading the view from its nib.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/






- (IBAction)loadAd:(id)sender {
    

    NSString * unitID;
    if(self.isCN){
        unitID = UNAD_TEST_UNIT_ID_REWARD_CN;
    }else {
        unitID = UNAD_TEST_UNIT_ID_REWARD;
    }
    
    self.rewardedAd = [[UNADRewardedAd alloc]initWithUnitID:unitID];
    self.rewardedAd.delegate = self;
    [self.rewardedAd loadAd];
   
    _statusLabel.text = @"加载中...";
}


- (IBAction)showAd:(id)sender {
    [self.rewardedAd showAdFromRootViewController:self];
    
}

#pragma mark - UNADRewardedAdDelegate

- (void)rewardedAdLoaded:(UNADRewardedAd *)rewardedAd
{
    _statusLabel.text = @"广告已经加载";
}
- (void)rewardedAd:(UNADRewardedAd *)rewardedAd didFailWithError:(NSError *)error
{
    NSString *message =   [ NSString stringWithFormat:@"广告加载失败:%@",error.localizedDescription];
    _statusLabel.text = message;
}
- (void)rewardedAdShown:(UNADRewardedAd *)rewardedAd
{
    _statusLabel.text = @"广告显示了";
}
- (void)rewardedAdClicked:(UNADRewardedAd *)rewardedAd
{
    _statusLabel.text = @"广告被点击";
}
- (void)rewardedAdDismissed:(UNADRewardedAd *)rewardedAd
{
    _statusLabel.text = @"广告已关闭,请重新加载";
    
}

//have reward
- (void)rewardedAdShouldRewardAd:(UNADRewardedAd *)rewardedAd
{
    _statusLabel.text = @"获得奖励";
}

@end
