//
//  InterstitialViewController.m
//  TestAdgo
//
//  Created by xiezuan on 2020/2/10.
//

#import "InterstitialViewController.h"
#import <UNAD/UNAD.h>

@interface InterstitialViewController ()<UNADInterstitialAdDelegate>

@property(nonatomic, strong)  UNADInterstitialAd *interstitialAD;


@end

@implementation InterstitialViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"插屏";
    


    // Do any additional setup after loading the view.
}


- (IBAction)loadAd:(id)sender {
    
    NSString * unitID;
  
    if(self.isCN){
        unitID = UNAD_TEST_UNIT_ID_INTERSTITIAL_CN;
    }else {
        unitID = UNAD_TEST_UNIT_ID_INTERSTITIAL;
    }
    
    
    self.interstitialAD = [[UNADInterstitialAd alloc]initWithUnitID:unitID];
    self.interstitialAD.delegate = self;
    self.interstitialAD.enableAudio = NO;

    if (_isFullScreenSwitch.isOn) {
        [self.interstitialAD loadAd];
    }else{
        [self.interstitialAD loadAd];
    }
    _statusLabel.text = @"加载中...";
}


- (IBAction)showAd:(id)sender {
    
    
    [self.interstitialAD showAdFromRootViewController:self];
    
}




/**
 广告已经加载
 */
- (void)interstitialAdLoaded:(UNADInterstitialAd *)interstitial
{
    _statusLabel.text = @"广告已经加载";
    
//    [self.interstitialAD showAdFromRootViewController:self];
}
/**
 广告加载失败
 */
- (void)interstitialAd:(UNADInterstitialAd *)interstitialAd didFailWithError:(NSError *)error
{
    NSString *message =   [ NSString stringWithFormat:@"广告加载失败:%@",error.localizedDescription];
    _statusLabel.text = message;
}
/**
 广告显示
 */
- (void)interstitialAdShown:(UNADInterstitialAd *)interstitial
{
    _statusLabel.text = @"广告显示";
}
/**
 广告点击
 */
- (void)interstitialAdClicked:(UNADInterstitialAd *)interstitial
{
    _statusLabel.text = @"广告被点击";
}
/**
 广告关闭
 */
- (void)interstitialAdDismissed:(UNADInterstitialAd *)interstitial
{
    _statusLabel.text = @"广告已关闭,请重新加载";
}

@end
