//
//  ViewController.m
//  testfont
//
//  Created by liumiao on 2021/4/27.
//

#import "GameViewController.h"
#import <WebKit/WebKit.h>
#import <UNAD/UNAD.h>


@interface GameViewController()<WKNavigationDelegate,WKUIDelegate,WKScriptMessageHandler,UNADInterstitialAdDelegate>

@property(nonatomic, strong)   WKWebView *wkwebView;
@property(nonatomic, strong)  UNADInterstitialAd *interstitialAD;
@property(nonatomic, assign) BOOL autoShowAd;
@property(nonatomic, assign) BOOL adLoaded;

@end




@implementation GameViewController

+(void)getIos:(NSString *)msg{
    NSLog(@"msg:%@",msg);
}



- (void)removeWebViewCache{
    NSArray *types = @[WKWebsiteDataTypeCookies, WKWebsiteDataTypeLocalStorage];
    NSSet *websiteDataTypes= [NSSet setWithArray:types];
    NSDate *dateFrom = [NSDate dateWithTimeIntervalSince1970:0];
    [[WKWebsiteDataStore defaultDataStore] removeDataOfTypes:websiteDataTypes modifiedSince:dateFrom completionHandler:^{
    }];

}

- (void)viewWillDisappear:(BOOL)animated {
    [self removeWebViewCache];
}



- (void)loadAd {
    
    self.interstitialAD = [[UNADInterstitialAd alloc]initWithUnitID:UNAD_TEST_UNIT_ID_INTERSTITIAL_CN];
    self.interstitialAD.delegate = self;
    [self.interstitialAD loadAd];
}



-(void)showAdIfA {
    if(self.adLoaded){
        [self.interstitialAD showAdFromRootViewController:self];
    }else{
        self.autoShowAd = YES;
        [self loadAd];
    }
}

- (void)viewDidLoad {

    
    /// 创建网页配置对象
    WKUserContentController *_userContentController = [[WKUserContentController alloc] init];
    // 遵守WKScriptMessageHandler协议。注册JS消息，name必须JS发送消息时的名字对应
    [_userContentController addScriptMessageHandler:self name:@"JumpToParentCenter"];


    WKWebViewConfiguration *_configuration = [[WKWebViewConfiguration alloc] init];

    
    _configuration.userContentController = _userContentController;
    _configuration.preferences.javaScriptEnabled = YES;
    _configuration.preferences.javaScriptCanOpenWindowsAutomatically = YES;
    _configuration.suppressesIncrementalRendering = YES; // 是否支持记忆读取
       [_configuration.preferences setValue:@YES forKey:@"allowFileAccessFromFileURLs"];
        if (@available(iOS 10.0, *)) {
             [_configuration setValue:@YES forKey:@"allowUniversalAccessFromFileURLs"];
        }

    
    self.wkwebView = [[WKWebView alloc] initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, self.view.frame.size.height) configuration:_configuration];
    [self.view addSubview:self.wkwebView];
    /// Load WebView

    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:@"http://39.108.12.80"]];
    [self.wkwebView loadRequest:request];

    
    // UI代理
    self.wkwebView.UIDelegate = self;
    // 导航代理
    self.wkwebView.navigationDelegate = self;
    // 是否允许手势左滑返回上一级, 类似导航控制的左滑返回
    self.wkwebView.allowsBackForwardNavigationGestures = YES;
    
    [self loadAd];
}

#pragma mark - WKScriptMessageHandler
/// 通过接收JS传出消息的name进行捕捉的回调方法
- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message
{
   
    NSLog(@"message.name:%@", message.name);
    NSLog(@"message.body:%@", message.body);
    ///阿拉拉拉 解析
    //调用js
    
    NSString *body =  [NSString stringWithFormat:@"%@",message.body];
    
    
    if([body isEqualToString:@"\"playVideoAd\""]) {
        [self showAdIfA];
    }
    
//    [self.wkwebView evaluateJavaScript:@"revMsg('bbbb')" completionHandler:^(id _Nullable response, NSError * _Nullable error) {
//           NSLog(@"error %@", error);
//       }];

}


/**
 广告已经加载
 */
- (void)interstitialAdLoaded:(UNADInterstitialAd *)interstitial
{
    //_statusLabel.text = @"广告已经加载";
    _adLoaded = YES;
    
    if(self.autoShowAd){
        [self.interstitialAD showAdFromRootViewController:self];
    }
}
/**
 广告加载失败
 */
- (void)interstitialAd:(UNADInterstitialAd *)interstitialAd didFailWithError:(NSError *)error
{
//    NSString *message =   [ NSString stringWithFormat:@"广告加载失败:%@",error.localizedDescription];
//    _statusLabel.text = message;
    
   // [self loadAd];
}
/**
 广告显示
 */
- (void)interstitialAdShown:(UNADInterstitialAd *)interstitial
{
    //_statusLabel.text = @"广告显示";
}
/**
 广告点击
 */
- (void)interstitialAdClicked:(UNADInterstitialAd *)interstitial
{
   // _statusLabel.text = @"广告被点击";
}
/**
 广告关闭
 */
- (void)interstitialAdDismissed:(UNADInterstitialAd *)interstitial
{
    
    _adLoaded = NO;
    self.autoShowAd = NO;
    [self loadAd];
   // _statusLabel.text = @"广告已关闭,请重新加载";
}


@end
