//
//  FeedViewController.m
//  TestUNAD
//
//  Created by xiezuan on 2021/10/12.
//

#import "FeedViewController.h"
#import <UNAD/UNAD.h>
#import "Common.h"


@interface FeedViewController ()<UITableViewDelegate,UITableViewDataSource,UNADFeedAdDelegate>

@property(nonatomic, strong) UITableView *tableView;
@property(nonatomic, strong) NSMutableArray *expressAdViews;
@property(nonatomic, strong) UNADFeedAd *feedAd;

@end

@implementation FeedViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"信息流";
    self.view.backgroundColor = [UIColor whiteColor];
    
    self.tableView = [UITableView new];
    self.tableView.separatorColor = [UIColor colorWithRed:0.31 green:0.31 blue:0.31 alpha:1];
    self.tableView.rowHeight = 50;
    self.tableView.sectionHeaderHeight = 30;
    
    self.tableView.dataSource = self;
    self.tableView.delegate = self;
    self.tableView.hidden = YES;
    self.tableView.backgroundColor = [UIColor whiteColor];
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"feedCell"];
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"splitfeedcell"];
    
    NSString * unitID;
    if(self.isCN){
        unitID = UNAD_TEST_UNIT_ID_FEED_CN;
    }else {
        unitID = UNAD_TEST_UNIT_ID_FEED;
    }
    
    self.feedAd = [[UNADFeedAd alloc]initWithUnitId:unitID adSize:CGSizeMake(SC_Width, 294)];
    self.feedAd.delegate = self;
    self.feedAd.rootViewController = self;
    
    //一次最多请求3个广告，可以在展示过后动态移除，不要申请太多的广告占用过多的资源。
    [self.feedAd loadAd:3];
    
    self.expressAdViews = [NSMutableArray array];
    
    [self.view addSubview:self.tableView];
    self.tableView.frame = self.view.bounds;
    
    // Do any additional setup after loading the view.
}


#pragma mark - UNADFeedAdDelegate
/**
 * 拉取广告成功的回调
 */

- (void)feedAdSuccessToLoad:(UNADFeedAd *)feedAd views:(NSArray<__kindof UNADFeedAdView *> *)views
{
    
    if (views.count) {
        [views enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            UNADFeedAdView *feedAdView = (UNADFeedAdView *)obj;
            feedAdView.controller = self;
            NSLog(@"渲染前信息流高度:%f",feedAdView.bounds.size.height);
            [feedAdView render];
            NSLog(@"信息流高度:%f",feedAdView.bounds.size.height);
            [self.expressAdViews addObject:feedAdView];
        }];
    }
    self.tableView.hidden = NO;
    [self.tableView reloadData];
}


- (void)feedAdViewRenderSuccess:(UNADFeedAdView *)feedAdView{
    NSLog(@"渲染后信息流高度:%f",feedAdView.bounds.size.height);
    self.tableView.hidden = NO;
    [self.tableView reloadData];
    
   
}


- (void)feedAdViewRenderFail:(UNADFeedAdView *)feedAdView{
    //渲染失败的单元要移掉
    
    NSLog(@"%s",__FUNCTION__);
    [self.expressAdViews removeObject:feedAdView];
    [self.tableView reloadData];
}


//国内的广告可以点击关闭，这时候要动态移除。
- (void)feedAdViewClosed:(UNADFeedAdView *)feedAdView{
    NSLog(@"%s",__FUNCTION__);
    
    //[self.tableView reloadData];
    
    [self.expressAdViews removeObject:feedAdView];
    NSUInteger index = [self.expressAdViews indexOfObject:feedAdView];
    NSIndexPath *indexPath=[NSIndexPath indexPathForRow:index inSection:0];
    [self.tableView reloadRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
}


- (void)feedAdViewDidShow:(UNADFeedAdView *)feedAdView
{
    //广告展示的回调
}




#pragma mark 自定义
//自定义Admob
/*
- (GADNativeAdView *)setupAdmobTemplate:(GADNativeAd *)nativeAd {

    GADTTemplateView *templateView;
    templateView = [[GADCustomTemplateView alloc] init];

    NSString *myBlueColor = @"#5C84F0";
    NSDictionary *styles = @{
        GADTNativeTemplateStyleKeyCallToActionFont : [UIFont systemFontOfSize:15.0],
        GADTNativeTemplateStyleKeyCallToActionFontColor : UIColor.whiteColor,
        GADTNativeTemplateStyleKeyCallToActionBackgroundColor :
            [UGADTTemplateView colorFromHexString:myBlueColor],
        GADTNativeTemplateStyleKeySecondaryFont : [UIFont systemFontOfSize:15.0],
        GADTNativeTemplateStyleKeySecondaryFontColor : UIColor.grayColor,
        GADTNativeTemplateStyleKeySecondaryBackgroundColor : UIColor.whiteColor,
        GADTNativeTemplateStyleKeyPrimaryFont : [UIFont systemFontOfSize:15.0],
        GADTNativeTemplateStyleKeyPrimaryFontColor : UIColor.blackColor,
        GADTNativeTemplateStyleKeyPrimaryBackgroundColor : UIColor.whiteColor,
        GADTNativeTemplateStyleKeyTertiaryFont : [UIFont systemFontOfSize:15.0],
        GADTNativeTemplateStyleKeyTertiaryFontColor : UIColor.grayColor,
        GADTNativeTemplateStyleKeyTertiaryBackgroundColor : UIColor.whiteColor,
        GADTNativeTemplateStyleKeyMainBackgroundColor : UIColor.whiteColor,
        GADTNativeTemplateStyleKeyCornerRadius : [NSNumber numberWithFloat:0.0],
    };
    templateView.styles = styles;
    templateView.nativeAd = nativeAd;
    return  templateView;
}

*/


#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row % 2 == 0) {
        UIView *view = [self.expressAdViews objectAtIndex:indexPath.row / 2];
        return view.bounds.size.height;
    }
    else {
        return 100;
    }
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.expressAdViews.count * 2;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    if (indexPath.row % 2 == 0) {
        cell = [self.tableView dequeueReusableCellWithIdentifier:@"feedCell" forIndexPath:indexPath];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        
        UIView *subView = (UIView *)[cell.contentView viewWithTag:1000];
        if ([subView superview]) {
            [subView removeFromSuperview];
        }
        UIView *view = [self.expressAdViews objectAtIndex:indexPath.row / 2];
        view.tag = 1000;
        [cell.contentView addSubview:view];
        cell.accessibilityIdentifier = @"nativeTemp_even_ad";
    } else {
        cell = [self.tableView dequeueReusableCellWithIdentifier:@"splitfeedcell" forIndexPath:indexPath];
        cell.backgroundColor = [UIColor grayColor];
        cell.accessibilityIdentifier = @"nativeTemp_odd_ad";
    }
    return cell;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/



@end
