//
//  ContentViewController.m
//  TestUNAD
//
//  Created by xiezuan on 2022/8/11.
//

#import "ContentViewController.h"
#import "XLPageViewController.h"
#import <Masonry/Masonry.h>
#import <UNAD/UNAD.h>



#define kIsBangsScreen ({\
    BOOL isBangsScreen = NO; \
    if (@available(iOS 11.0, *)) { \
    UIWindow *window = [[UIApplication sharedApplication].windows firstObject]; \
    isBangsScreen = window.safeAreaInsets.bottom > 0; \
    } \
    isBangsScreen; \
})



@interface ContentViewController ()<XLPageViewControllerDelegate,
XLPageViewControllerDataSrouce,
UNADVideoStateDelegate,
UNADHorizontalFeedCallBackProtocol,
UNADImageTextDetailDelegate,
UNADHorizontalFeedCallBackProtocol>

@property (nonatomic, strong) XLPageViewController *pageViewController;
@property(nonatomic, strong) NSMutableDictionary *feedPageDic;

@property(nonatomic, strong) UNADContentVideoFeed *doubleFeedVideo; //双Feed
@property(nonatomic, strong) UNADContentVideoFeed *singleSmallFeedVideo; //单Feed
@property(nonatomic, strong) UNADContentVideoFeed *singleBigFeedVideo; //单Feed
@property(nonatomic, strong) UNADContentTextFeed *textFeed; //单Feed
@property(nonatomic, strong) UNADContentHorizontalVideoFeed *horizontalVideoFeed; //横版视频


//@property(nonatomic, strong) UNADContentVideoFeed *singleFeedVideo; //单Feed




@end

@implementation ContentViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    

    
    [self initPageViewController];
    
    
}


- (void)initPageViewController {
    XLPageViewControllerConfig *config = [[XLPageViewControllerConfig alloc] init];
    config.titleSelectedColor = [UIColor colorWithRed:254/255.0f green:129/255.0f blue:1/255.0f alpha:1];
    config.titleNormalColor = [UIColor colorWithRed:51/255.0f green:51/255.0f blue:51/255.0f alpha:1];
    config.shadowLineHidden = true;
    config.titleSpace = 20;
    config.titleSelectedFont = [UIFont boldSystemFontOfSize:17];
    config.titleNormalFont = [UIFont systemFontOfSize:17];
    config.titleColorTransition = false;
    config.titleViewHeight = 40;
    self.pageViewController = [[XLPageViewController alloc] initWithConfig:config];
    self.pageViewController.delegate = self;
    self.pageViewController.dataSource = self;
    self.pageViewController.view.frame = self.view.bounds;
   
    [self addChildViewController:self.pageViewController];
    [self.view addSubview:self.pageViewController.view];
    [self.pageViewController.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(@0);
        make.right.equalTo(@0);
        make.top.equalTo(kIsBangsScreen?@(100):@(64));
        make.bottom.equalTo(@0);
    }];
    [self.pageViewController reloadData];
}





#pragma mark TableViewDelegate&DataSource

- (UIViewController *)pageViewController:(XLPageViewController *)pageViewController viewControllerForIndex:(NSInteger)index {
    UIViewController *vc = nil;
    switch (index) {
        case 0:{
            UNADContentVideoFeed *feedPage = nil;
            feedPage = [[UNADContentVideoFeed alloc] initWithUnitId:@"Adgo-unit-8070358068"];
            feedPage.videoStateDelegate = self;
            self.doubleFeedVideo = feedPage;
            vc = feedPage.feedViewController;
            [self.feedPageDic setObject:feedPage forKey:@(index)];
            break;
        }
        case 1:{
            UNADContentTextFeed *textFeed = nil;
            textFeed = [[UNADContentTextFeed alloc] initWithUnitId:@"Adgo-unit-6773141202"];
            textFeed.videoDetailDelegate = self;
            textFeed.imageTextDelegate = self;
    
            self.textFeed = textFeed;
            vc = textFeed.feedViewController;
            [self.feedPageDic setObject:textFeed forKey:@(index)];
            break;
        }
            
        case 2:{
            UNADContentHorizontalVideoFeed *feedPage = nil;
            feedPage = [[UNADContentHorizontalVideoFeed alloc] initWithUnitId:@"Adgo-unit-9814957110"];
            feedPage.videoDetailDelegate = self;
            self.horizontalVideoFeed = feedPage;
            vc = feedPage.feedViewController;
            [self.feedPageDic setObject:feedPage forKey:@(index)];
            break;
        }
        case 3:{
            UNADContentVideoFeed *feedPage = nil;
            feedPage = [[UNADContentVideoFeed alloc] initWithUnitId:@"Adgo-unit-6393016117"];
            feedPage.videoStateDelegate = self;
            self.singleSmallFeedVideo = feedPage;
            vc = feedPage.feedViewController;
            [self.feedPageDic setObject:feedPage forKey:@(index)];
            break;
        }
        case 4:{
            UNADContentVideoFeed *feedPage = nil;
            feedPage = [[UNADContentVideoFeed alloc] initWithUnitId:@"Adgo-unit-5563180107"];
            feedPage.videoStateDelegate = self;
            self.singleBigFeedVideo = feedPage;
            vc = feedPage.feedViewController;
            [self.feedPageDic setObject:feedPage forKey:@(index)];
            break;
        }
      
        default:{
            vc = [[UIViewController alloc] init];
        }
    }
    return vc;
}

- (NSString *)pageViewController:(XLPageViewController *)pageViewController titleForIndex:(NSInteger)index {
    return @[@"双Feed",@"图文",@"横版视频",@"单Feed小",@"单Feed大"][index];
}

- (NSInteger)pageViewControllerNumberOfPage {
    return 5;
}



- (NSMutableDictionary *)feedPageDic {
    if (!_feedPageDic) {
        _feedPageDic = [NSMutableDictionary dictionary];
    }
    return _feedPageDic;
}


- (void)pageViewController:(nonnull XLPageViewController *)pageViewController didSelectedAtIndex:(NSInteger)index {
    
}


#pragma mark - UNADVideoStateDelegate
/**
* 视频开始播放
* @param videoContent 内容模型
*/
- (void)unad_videoDidStartPlay:(UNADContentInfo*)videoContent
{
    
}
/**
* 视频暂停播放
* @param videoContent 内容模型
*/
- (void)unad_videoDidPause:(UNADContentInfo*)videoContent
{
    
}
/**
* 视频恢复播放
* @param videoContent 内容模型
*/
- (void)unad_videoDidResume:(UNADContentInfo*)videoContent
{
    
}
/**
* 视频停止播放
* @param videoContent 内容模型
* @param finished     是否播放完成
*/
- (void)unad_videoDidEndPlay:(UNADContentInfo*)videoContent isFinished:(BOOL)finished
{
    
}
/**
* 视频播放失败
* @param videoContent 内容模型
* @param error        失败原因
*/
- (void)unad_videoDidFailedToPlay:(UNADContentInfo*)videoContent withError:(NSError *)error
{
    
}



#pragma mark - UNADHorizontalFeedCallBackProtocol

/// 进入横版视频详情页
/// @param viewController 详情页VC
/// @param contentInfo 视频信息
- (void)unad_horizontalFeedDetailDidEnter:(UIViewController *)viewController contentInfo:(UNADContentInfo*)contentInfo
{
    
}

/// 离开横版视频详情页
/// @param viewController 详情页VC
- (void)unad_horizontalFeedDetailDidLeave:(UIViewController *)viewController
{
    
}

/// 视频详情页appear
/// @param viewController 详情页VC
- (void)unad_horizontalFeedDetailDidAppear:(UIViewController *)viewController
{
    
}

/// 详情页disappear
/// @param viewController 详情页VC
- (void)unad_horizontalFeedDetailDidDisappear:(UIViewController *)viewController
{
    
}


#pragma mark - UNADImageTextDetailDelegate
/// 进入图文详情页
/// @param detailViewController 图文详情页VC
/// @param feedId feedId
- (void)unad_imageTextDetailDidEnter:(UIViewController *)detailViewController feedId:(NSString *)feedId
{
    
}

/// 离开图文详情页
/// @param detailViewController 图文详情页VC
- (void)unad_imageTextDetailDidLeave:(UIViewController *)detailViewController
{
    
}

/// 图文详情页appear
/// @param detailViewController 图文详情页VC
- (void)unad_imageTextDetailDidAppear:(UIViewController *)detailViewController
{
    
}

/// 图文详情页disappear
/// @param detailViewController 图文详情页VC
- (void)unad_imageTextDetailDidDisappear:(UIViewController *)detailViewController
{
    
}

/// 图文详情加载结果
/// @param detailViewController 图文详情页VC
/// @param success 是否成功
/// @param error error
- (void)unad_imageTextDetailDidLoadFinish:(UIViewController *)detailViewController success:(BOOL)success error:(NSError *)error
{
    
}

/// 图文详情阅读进度
/// @param detailViewController 图文详情页VC
/// @param isFold 是否折叠
/// @param totalHeight 详情总高度
/// @param seenHeight 已经看过的高度
- (void)unad_imageTextDetailDidScroll:(UIViewController *)detailViewController isFold:(BOOL)isFold totalHeight:(CGFloat)totalHeight seenHeight:(CGFloat)seenHeight
{
    
}



@end
