//
//  BannerViewController.m
//  TestAdgo
//
//  Created by xiezuan on 2020/2/10.
//

#import "BannerViewController.h"
#import <UNAD/UNAD.h>
#import "Common.h"




@interface BannerViewController ()<UNADBannerViewDelegate>


@property(nonatomic, strong)  UNADBannerView *bannerView;

@end

@implementation BannerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.edgesForExtendedLayout = UIRectEdgeNone;
    
    self.view.backgroundColor = [UIColor whiteColor];
    //UNAD_TEST_UNIT_ID
    NSString *unitID = @"";
    if(self.isCN){
        unitID = UNAD_TEST_UNIT_ID_BANNER_CN;
    }else {
        unitID = UNAD_TEST_UNIT_ID_BANNER;
    }
    
    self.bannerView = [[UNADBannerView alloc]initWithUnitID:unitID rootViewController:self];
    self.bannerView.delegate = self;
    self.title = @"横幅";
    [self.view addSubview:_bannerView];
    _bannerView.frame = CGRectMake(0, 10,SC_Width , 60);
    [_bannerView loadAd];
    // Do any additional setup after loading the view.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/


- (UIEdgeInsets)safeAreaInsets {
    if (@available(iOS 11.0, *)) {
        UIWindow *mainWindow = [[[UIApplication sharedApplication] delegate] window];
        return mainWindow.safeAreaInsets;
    }else{
        return UIEdgeInsetsMake(0, 0, 0, 0);
    }
}


/**
 Banner加载成功
 */
- (void)bannerDidReceiveAd:(UNADBannerView *)bannerView
{
    
}

/**
 Banner点击
 */
- (void)bannerDidClick:(UNADBannerView *)bannerView
{
    
}

/**
 广告显示被关闭
 */
- (void)adDidClose:(UNADBannerView *)bannerView
{
    
}

/**
 Banner请求失败
 */
- (void)banner:(UNADBannerView *)bannerView didFailToLoadAdWithError:(AdGrowRequestError *)error
{
    
}



/**
 广告弹出全屏
 */
- (void)adWillPresentFullScreen:(UNADBannerView *)bannerView
{
    
}


/**
 广告从全屏半闭
 */
- (void)adWillDismissFullScreen:(UNADBannerView *)bannerView
{
    
}

@end
