//
//  SceneDelegate.m
//  AdgoDemo
//
//  由xiezuan于2020/12/20创建。
//

#import "SceneDelegate.h" // 导入SceneDelegate头文件
#import <UNAD/UNAD.h> // 导入UNAD库
#import <AppTrackingTransparency/AppTrackingTransparency.h>
#import "ViewController.h"
#import "SettingViewController.h"

@interface SceneDelegate ()<UNADSplashDelegate> // SceneDelegate接口声明

@property (nonatomic, strong) UNADSplash *splash;
@property(nonatomic, assign) BOOL isChina;
//上一次展示广告的时间
@property (assign, nonatomic) NSTimeInterval lastShowTime;


@end

@implementation SceneDelegate // SceneDelegate的实现


//给当前代码加上注释


- (UIImage *)getLaunchImage { // 获取启动图片的方法
   
    UIViewController *LaunchScreenSb = [[UIStoryboard storyboardWithName:@"LaunchScreen" bundle:nil] instantiateInitialViewController]; // 从LaunchScreen故事板中实例化初始视图控制器
    if (LaunchScreenSb) { // 如果成功获取到了视图控制器
        UIView * view = LaunchScreenSb.view; // 获取视图
        // 加入到UIWindow后，LaunchScreenSb.view的safeAreaInsets在刘海屏机型才正常。
        UIWindow *containerWindow = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds]; // 创建一个新的窗口
        view.frame = containerWindow.bounds; // 设置视图的大小和位置
        [containerWindow addSubview:view]; // 将视图添加到窗口
        [containerWindow layoutIfNeeded]; // 强制窗口立即更新其子视图的布局
        UIImage *image = [self imageFromView:view]; // 从视图中获取图片
        containerWindow = nil; // 释放窗口
        return image; // 返回图片
    }
    NSLog(@"从 LaunchScreen 中获取启动图失败!"); // 如果无法从LaunchScreen中获取启动图，打印错误信息
    return nil; // 返回nil
}

-(UIImage *)imageFromView:(UIView*)view { // 从视图中获取图片的方法
    //fix bug:https://github.com/CoderZhuXH/XHLaunchAd/issues/203
    if (CGRectIsEmpty(view.frame)) { // 如果视图的frame是空的
        return nil; // 返回nil
    }
    CGSize size = view.bounds.size; // 获取视图的大小
    //参数1:表示区域大小 参数2:如果需要显示半透明效果,需要传NO,否则传YES 参数3:屏幕密度
    UIGraphicsBeginImageContextWithOptions(size, NO, [UIScreen mainScreen].scale); // 开始图形上下文
    if ([view respondsToSelector:@selector(drawViewHierarchyInRect:afterScreenUpdates:)]) { // 如果视图响应drawViewHierarchyInRect:afterScreenUpdates:方法
        [view drawViewHierarchyInRect:view.bounds afterScreenUpdates:YES]; // 在视图的边界内绘制视图层次结构
    }else{ // 如果视图不响应drawViewHierarchyInRect:afterScreenUpdates:方法
        [view.layer renderInContext:UIGraphicsGetCurrentContext()]; // 在当前的图形上下文中渲染视图的图层
    }
    UIImage * image = UIGraphicsGetImageFromCurrentImageContext(); // 从当前的图形上下文中获取图片
    UIGraphicsEndImageContext(); // 结束图形上下文
    return image; // 返回图片
}

- (NSString *)getCurrentCountry {
    
    if (@available(iOS 10.0, *)) {
        NSString *country = [NSLocale currentLocale].countryCode;
        return country;
    } else {
        NSLocale *locale = [NSLocale currentLocale];
        NSString *countryCode = [locale objectForKey: NSLocaleCountryCode];
        NSString *country = [locale displayNameForKey: NSLocaleCountryCode value: countryCode];
        return country;
    }
    
}

- (void)loadAd {
    //开屏广告初始化并展示代码
    if(!self.splash) {
        self.splash = [[UNADSplash alloc]initWithUnitID:_isChina?UNAD_TEST_UNIT_ID_SPLASH_CN:UNAD_TEST_UNIT_ID_SPLASH
                                                   lifeTime:5
                                                 fetchDelay:5];
        UIImage *splashImage = [self getLaunchImage];
        self.splash.backgroundImage = splashImage;
        self.splash.delegate = self;
    }
    
    [self.splash loadAndShow:self.window.rootViewController];
}



- (void)scene:(UIScene *)scene willConnectToSession:(UISceneSession *)session options:(UISceneConnectionOptions *)connectionOptions  API_AVAILABLE(ios(13.0)){ // 场景将要连接到会话的方法
    
    self.window.backgroundColor = [UIColor whiteColor];
    
    self.isChina =  [[[self getCurrentCountry]uppercaseString]isEqualToString:@"CN"];
    
    [self setRootVC];
    

    // Use this method to optionally configure and attach the UIWindow `window` to the provided UIWindowScene `scene`.
    // If using a storyboard, the `window` property will automatically be initialized and attached to the scene.
    // This delegate does not imply the connecting scene or session are new (see `application:configurationForConnectingSceneSession` instead).
}


- (void)sceneDidDisconnect:(UIScene *)scene  API_AVAILABLE(ios(13.0)){ // 场景已经断开连接的方法
    // Called as the scene is being released by the system.
    // This occurs shortly after the scene enters the background, or when its session is discarded.
    // Release any resources associated with this scene that can be re-created the next time the scene connects.
    // The scene may re-connect later, as its session was not necessarily discarded (see `application:didDiscardSceneSessions` instead).
}


- (void)sceneDidBecomeActive:(UIScene *)scene  API_AVAILABLE(ios(13.0)){ // 场景已经变成活动状态的方法
    // Called when the scene has moved from an inactive state to an active state.
    // Use this method to restart any tasks that were paused (or not yet started) when the scene was inactive.
}


- (void)sceneWillResignActive:(UIScene *)scene  API_AVAILABLE(ios(13.0)){ // 场景将要放弃活动状态的方法
    // Called when the scene will move from an active state to an inactive state.
    // This may occur due to temporary interruptions (ex. an incoming phone call).
}


- (void)sceneWillEnterForeground:(UIScene *)scene  API_AVAILABLE(ios(13.0)){ // 场景将要进入前台的方法
    // Called as the scene transitions from the background to the foreground.
    // Use this method to undo the changes made on entering the background.
    
   [UNADSplash showLaunchImage:[self getLaunchImage]]; // 显示启动图片
    
    //获取IDFA 权限
//    if (@available(iOS 14, *)) {
//        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
//        }];
//    }

    //自己根据需求再去调整展示的时机，比如30分钟只能展示一次,Demo中是5秒
    NSTimeInterval nowTime =  [[NSDate date]timeIntervalSince1970];
    if(nowTime - self.lastShowTime > 5) {
        [self loadAd];
    }
    
    self.lastShowTime = [[NSDate date]timeIntervalSince1970];
  
}


- (void)sceneDidEnterBackground:(UIScene *)scene  API_AVAILABLE(ios(13.0)){ // 场景已经进入后台的方法
    // Called as the scene transitions from the foreground to the background.
    // Use this method to save data, release shared resources, and store enough scene-specific state information
    // to restore the scene back to its current state.
}


//跳转到主界面
- (void)setRootVC {
    //跳转到主界面

    
    ViewController *rootViewController = [[ViewController alloc]init];
    
    UINavigationController *navViewController = [[UINavigationController alloc]initWithRootViewController:rootViewController];
    
    UITabBarController * tabbarVC = [[UITabBarController alloc]init];
    rootViewController.tabBarItem.title = @"测试";
    rootViewController.tabBarItem.image = [UIImage imageNamed:@"tabbar_image0"];
//    rootViewController.tabBarItem.selectedImage = [UIImage imageNamed:@"tabBar_new_click_icon"];
    //rootViewController.view.backgroundColor = [UIColor redColor];
    [tabbarVC addChildViewController:navViewController];
    

    SettingViewController *rootViewController2 = [[SettingViewController alloc]init];
    UINavigationController *navViewController2 = [[UINavigationController alloc]initWithRootViewController:rootViewController2];
    rootViewController2.tabBarItem.title = @"设置";
    rootViewController2.tabBarItem.image = [UIImage imageNamed:@"tabbar_image1"];
//    rootViewController2.tabBarItem.selectedImage = [UIImage imageNamed:@"tabBar_new_click_icon"];
    //rootViewController.view.backgroundColor = [UIColor redColor];
    [tabbarVC addChildViewController:navViewController2];
    self.window.rootViewController = tabbarVC;
    
  //  self.isFirstLoad = NO;
  
}




/**
 开屏展现
 */
- (void)splashDidPresentScreen:(UNADSplash *)splash;
{
    NSLog(@"开屏展现广告");
    
}


/**
 开屏消失
 */
- (void)splashDidDismissScreen:(UNADSplash *)splash;
{
    NSLog(@"开屏消失");
}

/**
 开屏请求失败
 */
- (void)splash:(UNADSplash *)splash didFailWithError:(NSError *)error;
{
    NSLog(@"开屏请求失败：%@",error.description);
}

/**
 开屏点击
 */
- (void)splashDidClick:(UNADSplash *)splash
{
    NSLog(@"开屏被点击");
}



@end // 结束SceneDelegate的实现

