//
//  Common.h
//  SDKDemo
//
//  Created by xiezuan on 2020/3/11.
//

#ifndef Common_h
#define Common_h

#define SC_Height [[UIScreen mainScreen]bounds].size.height
#define SC_Width  [[UIScreen mainScreen]bounds].size.width


static inline BOOL isIPhoneX() {
    if (@available(iOS 11.0, *)) {
        UIWindow *mainWindow = [[[UIApplication sharedApplication] delegate] window];
        if (mainWindow.safeAreaInsets.bottom > 0.0) {
            return YES;
        }
    }else{
        return  (SC_Height == 812.0f || SC_Height == 896.0f);
    }
    return NO;
}

static inline BOOL isIPhoneX_L() {
    if (@available(iOS 11.0, *)) {
        UIWindow *mainWindow = [[[UIApplication sharedApplication] delegate] window];
        if (mainWindow.safeAreaInsets.bottom > 0.0) {
            return YES;
        }
    }else{
        return  (SC_Width == 812.0f || SC_Height == 896.0f);
    }
    return NO;
}




#define IS_IPHONE_X isIPhoneX()

#define IS_IPHONE_X_L isIPhoneX_L() //横屏时

#define Screen_TOP_VIEW_HEIGHT   44  //title

#define Height_StatusBar  ((IS_IPHONE_X) ? 44.0f: 20.0f)

#define Height_TabBar    ((IS_IPHONE_X) ? 83.0f: 49.0f)



#define Screen_TOP_NAVBAR_VIEW_HEIGHT  ((IS_IPHONE_X) ? 88.0f: 64.0f)

#define SafeArea_Landscape_BOTTOM  ((IS_IPHONE_X_L) ? 34.0f:0.0f)

#define SafeArea_BOTTOM  ((IS_IPHONE_X) ? 34.0f:0.0f)

#define SafeArea_HEAD_HEIGHT  ((IS_IPHONE_X) ? 28.0f:0.0f)

#define SafeArea_Top_HEIGHT  ((IS_IPHONE_X) ? 44.0f:0.0f)


#endif /* Common_h */
