//
//  AppDelegate.m
//  AdgoDemo
//
//  Created by xiezuan on 2020/12/20.
//

#import "AppDelegate.h"
#import <UNAD/UNAD.h>
#import "ViewController.h"
#import <AppTrackingTransparency/AppTrackingTransparency.h>
#import "QWechatManager.h"
#import "SettingViewController.h"


@interface AppDelegate ()<UNADSplashDelegate>

@property (nonatomic, strong) UNADSplash *splash;
@property(nonatomic, assign) BOOL isFirstLoad;
@property(nonatomic, assign) BOOL isChina;

//上一次展示广告的时间
@property (assign, nonatomic) NSTimeInterval lastShowTime;



@end

@implementation AppDelegate



- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.
    
    self.isFirstLoad = YES;
    self.isChina =  [[[self getCurrentCountry]uppercaseString]isEqualToString:@"CN"];
    
    if (@available(iOS 13.0, *)) {
        //ios 13以上通过 storyboard 启动,SceneDelegate管理

    } else {
        //ios 13以下通过
         [self setRootVC];
    }
    
   
    
    
    UNADConfig *config =  [UNADConfig new];
    config.disablePersonalRecommend = NO;
           //在初始化方法调用前根据系统地区来设置 国内 和国外
    [UNAD setArea:self.isChina?UNADAreaCN:UNADAreaOther];
    [UNAD initWithAppID:UNAD_TEST_APPID_IOS
                 config:config
                success:^{
        
    } fail:^(NSError * error) {
        NSLog(@"init fail %@",error.localizedDescription);
    }];

    return YES;
}


//ios以下
- (void)setRootVC {
    UINavigationController *nav = [[UINavigationController alloc]initWithRootViewController:[ViewController new]];
    self.window = [[UIWindow alloc]initWithFrame:[UIScreen mainScreen].bounds];
    self.window.rootViewController = nav;
    [self.window makeKeyAndVisible];
    
    ViewController *rootViewController = [[ViewController alloc]init];
    
    UINavigationController *navViewController = [[UINavigationController alloc]initWithRootViewController:rootViewController];
    
    UITabBarController * tabbarVC = [[UITabBarController alloc]init];
    rootViewController.tabBarItem.title = @"测试";
    rootViewController.tabBarItem.image = [UIImage imageNamed:@"tabbar_image0"];
//    rootViewController.tabBarItem.selectedImage = [UIImage imageNamed:@"tabBar_new_click_icon"];
    //rootViewController.view.backgroundColor = [UIColor redColor];
    [tabbarVC addChildViewController:navViewController];
    

    SettingViewController *rootViewController2 = [[SettingViewController alloc]init];
    UINavigationController *navViewController2 = [[UINavigationController alloc]initWithRootViewController:rootViewController2];
    rootViewController2.tabBarItem.title = @"设置";
    rootViewController2.tabBarItem.image = [UIImage imageNamed:@"tabbar_image1"];
//    rootViewController2.tabBarItem.selectedImage = [UIImage imageNamed:@"tabBar_new_click_icon"];
    //rootViewController.view.backgroundColor = [UIColor redColor];
    [tabbarVC addChildViewController:navViewController2];
    self.window.rootViewController = tabbarVC;
}




- (void)applicationDidBecomeActive:(UIApplication *)application{
    
    //获取IDFA 权限
//    if (@available(iOS 14, *)) {
//        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
//        }];
//    }

    //自己根据需求再去调整展示的时机，比如30分钟只能展示一次,Demo中是5秒
    NSTimeInterval nowTime =  [[NSDate date]timeIntervalSince1970];
    if(nowTime - self.lastShowTime > 5) {
        [self loadAd];
    }
    
    self.lastShowTime = [[NSDate date]timeIntervalSince1970];
    
}





- (NSString *)getCurrentCountry {
    
    if (@available(iOS 10.0, *)) {
        NSString *country = [NSLocale currentLocale].countryCode;
        return country;
    } else {
        NSLocale *locale = [NSLocale currentLocale];
        NSString *countryCode = [locale objectForKey: NSLocaleCountryCode];
        NSString *country = [locale displayNameForKey: NSLocaleCountryCode value: countryCode];
        return country;
    }
    
}

#pragma mark - 广告
//初始化广告


- (void)loadAd {
    //开屏广告初始化并展示代码
    if(!self.splash) {
        self.splash = [[UNADSplash alloc]initWithUnitID:_isChina?UNAD_TEST_UNIT_ID_SPLASH_CN:UNAD_TEST_UNIT_ID_SPLASH
                                                   lifeTime:5
                                                 fetchDelay:5];
        UIImage *splashImage = [self getLaunchImage]; //[UIImage imageNamed:@"launchbg"];
        self.splash.backgroundImage = splashImage;
        self.splash.delegate = self;
    }
    
    [self.splash loadAndShow:self.window.rootViewController];
}





- (UIImage *)getLaunchImage {
   
    UIViewController *LaunchScreenSb = [[UIStoryboard storyboardWithName:@"LaunchScreen" bundle:nil] instantiateInitialViewController];
    if (LaunchScreenSb) {
        UIView * view = LaunchScreenSb.view;
        // 加入到UIWindow后，LaunchScreenSb.view的safeAreaInsets在刘海屏机型才正常。
        UIWindow *containerWindow = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
        view.frame = containerWindow.bounds;
        [containerWindow addSubview:view];
        [containerWindow layoutIfNeeded];
        UIImage *image = [self imageFromView:view];
        containerWindow = nil;
        return image;
    }
    NSLog(@"从 LaunchScreen 中获取启动图失败!");
    return nil;
}

-(UIImage *)imageFromView:(UIView*)view {
    //fix bug:https://github.com/CoderZhuXH/XHLaunchAd/issues/203
    if (CGRectIsEmpty(view.frame)) {
        return nil;
    }
    CGSize size = view.bounds.size;
    //参数1:表示区域大小 参数2:如果需要显示半透明效果,需要传NO,否则传YES 参数3:屏幕密度
    UIGraphicsBeginImageContextWithOptions(size, NO, [UIScreen mainScreen].scale);
    if ([view respondsToSelector:@selector(drawViewHierarchyInRect:afterScreenUpdates:)]) {
        [view drawViewHierarchyInRect:view.bounds afterScreenUpdates:YES];
    }else{
        [view.layer renderInContext:UIGraphicsGetCurrentContext()];
    }
    UIImage * image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
}




#pragma mark- UNADSplashDelegate

//自定义底部视图，此方法只有国内的广告才有效，国外广告无效
//- (UIView *)splashBottomView
//{
//    CGFloat logoHeight = 135;
//    UIView *bottomView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, [[UIScreen mainScreen] bounds].size.width, logoHeight)];
//    bottomView.backgroundColor = [UIColor whiteColor];
//    UIImageView *logo = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"SplashLogo"]];
//    logo.accessibilityIdentifier = @"splash_logo";
//    logo.frame = CGRectMake(0, 0, 311, 47);
//    logo.center = bottomView.center;
//    [bottomView addSubview:logo];
//    return  bottomView;
//    
//}
//


/**
 开屏展现
 */
- (void)splashDidPresentScreen:(UNADSplash *)splash;
{
    NSLog(@"开屏展现广告");
    
}


/**
 开屏消失
 */
- (void)splashDidDismissScreen:(UNADSplash *)splash;
{
    NSLog(@"开屏消失");
  
}

/**
 开屏请求失败
 */
- (void)splash:(UNADSplash *)splash didFailWithError:(NSError *)error;
{
    NSLog(@"开屏请求失败：%@",error.description);

}

/**
 开屏点击
 */
- (void)splashDidClick:(UNADSplash *)splash
{
    NSLog(@"开屏被点击");
}





//若只支持iOS 9+，只保留下方两个回调即可：
- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey, id> *)options{
    
    return [[QWechatManager shareInstance]handleOpenURL:url];
    
}

#pragma mark Universal Link
- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray<id<UIUserActivityRestoring>> * __nullable restorableObjects))restorationHandler {
    return [[QWechatManager shareInstance] application:application continueUserActivity:userActivity restorationHandler:restorationHandler];

}
@end

