# XCode15 问题

## pod失败问题

如何升级了 XCode 15 报以下的错误的话，请在podfile 中加入以下这一段

```
Error 'DT_TOOLCHAIN_DIR cannot be used to evaluate LIBRARY_SEARCH_PATHS, use TOOLCHAIN_DIR instead'
```

```
post_install do |installer|
      installer.pods_project.targets.each do |target|
          target.build_configurations.each do |config|
          xcconfig_path = config.base_configuration_reference.real_path
          xcconfig = File.read(xcconfig_path)
          xcconfig_mod = xcconfig.gsub(/DT_TOOLCHAIN_DIR/, "TOOLCHAIN_DIR")
          File.open(xcconfig_path, "w") { |file| file << xcconfig_mod }
          end
      end
  end
```

### 兼容ios12问题

升级xcode15 后，ios12运行闪退。

1.Building Settings -> Other Linker Flags 加入以下参数 

```
-ld_classic
```

2.Building Settings -> Alwasy Embed Swift Standard Librarys 设为YES











## 1.更新podfile 

```
pod 'AliyunLogProducer', '3.1.16'
pod 'GDTMobSDK', '4.14.42'
pod 'KSAdSDK', '3.3.51.1'
pod 'Ads-CN','5.6.0.7'
pod 'JADYun','2.2.8'
pod 'KlevinAdSDK', '~>2.10.1'
pod 'MintegralAdSDK/All','7.3.7'
pod 'BaiduMobAdSDK','5.300'
pod 'Ads-Global','5.3.1.1'
pod 'IronSourceSDK','7.3.0.0'
pod 'MintegralAdSDK/All','7.3.7'
pod 'BigoADS','2.3.4'
pod 'Google-Mobile-Ads-SDK','10.5.0'
pod 'GoogleMobileAdsMediationFacebook','6.12.0.1'
pod 'GoogleMobileAdsMediationVungle','6.12.3.0'
pod 'GoogleMobileAdsMediationAdColony','4.9.0.2'
pod 'AmazonPublisherServicesSDK','4.7.5'

```



## 2.更新

1.修改信息流尺寸太高的问题

2.修复部分广告源信息流在收到内存警告时可能释放。

3.优化开屏广告加载机制。
