## 欧盟地区用户意见征求政策

根据 Google [欧盟地区用户意见征求政策](https://www.google.com/about/company/user-consent-policy/?authuser=0&hl=zh-cn)，您必须向位于欧洲经济区 (EEA) 和英国境内的用户披露相关信息，在法律有相应要求的情况下，必须就 Cookie 或其他本地存储方式的使用征得他们的同意，并使用个人数据（例如 AdID）来投放广告。 此政策反映了欧盟《电子隐私指令》和《一般数据保护条例》(GDPR) 的要求。





#### 1. 在您的主要的MainActivity增加下面方法

```java

    private void loadAndShowConsentFormIfRequired(){
        GoogleMobileAdsConsentManager manage=  GoogleMobileAdsConsentManager.getInstance(this);
        //添加模拟测试设备ID和模拟欧盟用户经纬度 请参考gatherConsent中方法
        manage.gatherConsent(this,new GoogleMobileAdsConsentManager.OnConsentGatheringCompleteListener(){

            @Override
            public void consentGatheringComplete(FormError error) {

                if(manage.canRequestAds()){
                    Log.e("UNAD_SDK","通过");
                }
            }
        });
    }
```

当用户是欧盟用户，并且没有选择过隐私授权表单，调用此方法会弹出以下表单界面，当用户选择同意或者拒绝之后，在13个月的有效期内此方法不会再弹出隐私授权表单。所以建议每次都调用此方法，当失效后又会弹出让用户自己选择。

<img src="https://carewhat.oss-cn-shenzhen.aliyuncs.com/uPic/20231208082004.png" style="zoom:25%;" />

#### 2. 在您的设置中增加用户隐私修改按钮

意见征求表单要求允许用户随时修改其同意声明。请按照以下步骤实现隐私设置选项按钮。

注意，这个选项是在已经弹出过征求表单窗口后的设备才显示，可根据以下代码判断是否显示按钮

```java
   通过isPrivacyOptionsRequired()判断是否已经显示过
```

点击隐私按钮调用弹出修改隐私表单窗口，表单和第一次弹出的显示一样，但方法不同。

```java
 GoogleMobileAdsConsentManager.getInstance(this).showPrivacyOptionsForm(this,new ConsentForm.OnConsentFormDismissedListener(){
            public void onConsentFormDismissed(@Nullable FormError formError) {
               
        });
```

参考图：

<img src="https://carewhat.oss-cn-shenzhen.aliyuncs.com/uPic/20231208082227.png" style="zoom:55%;" />

#### 4. 测试模拟欧盟用户

GoogleMobileAdsConsentManager 类中放开`setDebugGeography(ConsentDebugSettings.DebugGeography.DEBUG_GEOGRAPHY_EEA) `代码的屏蔽
该代码表示模拟欧盟地区。

查看日志 找到类似`Use new ConsentDebugSettings.Builder().addTestDeviceHashedId("ABCDEF012345")`
把日志中的设备id添加到您的代码中去 .addTestDeviceHashedId("你日志中看到的设备id")这样就可以进行UMP的测试了。

**注意,测试时必须要翻墙。**

参考图：

<img src="https://carewhat.oss-cn-shenzhen.aliyuncs.com/uPic/20231208082754.png" style="zoom:100%;" />



**详细参考DEMO中的 MainActivity**

**注意，上线的版本需要屏蔽setDebugGeography(ConsentDebugSettings.DebugGeography.DEBUG_GEOGRAPHY_EEA) 和.addTestDeviceHashedId("你日志中看到的设备id")**
**注意，上线的版本需要屏蔽setDebugGeography(ConsentDebugSettings.DebugGeography.DEBUG_GEOGRAPHY_EEA) 和.addTestDeviceHashedId("你日志中看到的设备id")**
**注意，上线的版本需要屏蔽setDebugGeography(ConsentDebugSettings.DebugGeography.DEBUG_GEOGRAPHY_EEA) 和.addTestDeviceHashedId("你日志中看到的设备id")**
