## 一、简介

主要介绍在Android项目中如何集成 UNAD SDK的信息流广告：

## 二、集成

## 1、在自己的Application 中初始化SDK

adgo-app-8379418688为测试appid，上线请替换正式的APPID

```java
 
	  String curProcessName = getProcessName(this);
        if (curProcessName != null && curProcessName.equalsIgnoreCase(this.getPackageName())) {
            //请填写您的APPID
            String unadAppid = "adgo-app-8379418688";
            // 主线程通过调用此方法初始化 SDK。
            UNAD.initialize(unadAppid, getApplicationContext(), new UNAD.InitCallback() {
                @Override
                public void onSuccess() {
                    Log.i(TAG, "onSuccess");
                }

                @Override
                public void onError(AdError error) {
                    Log.i(TAG, "error:" + error.getMessage());
                }

            });
        }
		
```

## 2、初始化广告并监听

```java
   mADManager = new UNADFeedAd(this, "UNAD_TEST_UNIT_ID", new UNADFeedAd.AdViewListener(){
       
            public void onAdLoaded(UNADFeedAdView unadFeedAdView) {
            }


            @Override
            public void onAdFailed(AdError error) {
            }

            @Override
            public void onAdClicked(UNADFeedAdView unadFeedAdView) {
            }

            @Override
            public void onAdClose(UNADFeedAdView unadFeedAdView) {
                //移除布局
                adlayout.removeView(unadFeedAdView);
            }

            @Override
            public void onAdOpen(UNADFeedAdView unadFeedAdView) {
            }


        });
```

## 3、拉取广告

```java
 mADManager.loadAd();
```

## 4、渲染广告

```java
//用广告返回的视图去打开
unadFeedAdView.render(); 
```

## 5、Admob自定义模板

```java
//第一步：
mADManager.setAdmobTemplate(true);

//第二步：初始化布局文件
    if(unadFeedAdView.getAdmobNative()!=null){
                    NativeAdView adView = (NativeAdView) LayoutInflater.from(FeedActivity.this).inflate(R.layout.native_ad_unified, null);
                    populateNativeAdView(unadFeedAdView.getAdmobNative(), adView);
        //渲染
                    unadFeedAdView.render(adView);
 }
//可自行对native_ad_unified进行位置调整，详细参考DEMO FeedActivity.java
```



## 6.自定义Admob模板可进行自定义关闭按钮

```java
mADManager.setAdmobRequestCustomMuteThisAd(true);
```

注意:

(1) 自定义的关闭按钮一定不能与其它元素重叠

(2).打开了自定义关闭广告选项后，在实现自定义关闭按钮时要判断返回的广告是否允许关闭,有些广告不允许关闭。

```java
if(nativeAd.isCustomMuteThisAdEnabled()){
//返回广告可以自定义关闭按钮
}else{
//返回广告不可以自定义关闭按钮，不要显示按钮
}
```

(3).如果选择了原因需要进行记录原因如下：

```java
nativeAd.muteThisAd(reason);
```

(4).建议在监听记录广告关闭原因回调后隐藏和销毁广告

```java
  nativeAd.setMuteThisAdListener(new MuteThisAdListener() {
                @Override
                public void onAdMuted() {
                   //删除广告
                    //这里需要移除布局
                }
            });
```




## 7、注意事项

1、测试广告位ID UNAD_TEST_UNIT_ID   **应用上线时请替换为正式的广告位ID**

2、**当系统的onResume被调用时候，必须要调用mADManager的onResume方法** 

**当系统的onPause被调用时候，必须要调用mADManager的onPause方法**  

3、有需要时可以进行资源的销毁
```
UNADFeedAdView.destroy();
mADManager.release();
```

