## 一、简介

主要介绍在Android项目中如何集成 UNAD SDK的横幅广告：

## 二、集成

## 1、在自己的Application 中初始化SDK

adgo-app-8379418688为测试appid，上线请替换正式的APPID

```java
  String curProcessName = getProcessName(this);
        if (curProcessName != null && curProcessName.equalsIgnoreCase(this.getPackageName())) {
            //请填写您的APPID
            String unadAppid = "adgo-app-8379418688";
            // 主线程通过调用此方法初始化 SDK。
            UNAD.initialize(unadAppid, getApplicationContext(), new UNAD.InitCallback() {
                @Override
                public void onSuccess() {
                    Log.i(TAG, "onSuccess");
                }

                @Override
                public void onError(AdError error) {
                    Log.i(TAG, "error:" + error.getMessage());
                }

            });
        }
```

## 2、添加广告布局

在您要展示横幅的位置加上下面布局

```java
 <androidx.constraintlayout.widget.ConstraintLayout
        android:layout_width="match_parent"
        android:layout_height="match_parent"
        app:layout_behavior="@string/appbar_scrolling_view_behavior">
        <LinearLayout
            android:layout_width="match_parent"
            android:layout_height="match_parent">
            <com.unad.sdk.UNADBannerView
                android:id="@+id/ad_banner_view"
                android:layout_width="match_parent"
                android:layout_height="wrap_content"
                android:visibility="visible">
            </com.unad.sdk.UNADBannerView>
        </LinearLayout>
    </androidx.constraintlayout.widget.ConstraintLayout>
```

## 3、设置广告ID

```java
  bannerContainer.setAdUnitId("UNAD_TEST_UNIT_ID");

```

## 5、监听状态

```java

        bannerContainer.setAdViewListener(new UNADBannerView.AdViewListener(){

            @Override
            public void onAdViewLoaded(UNADBannerView tradPlusView) {
                Log.i(TAG,"Banner onAdViewLoaded");
            }

            @Override
            public void onAdViewFailed(UNADBannerView tradPlusView, AdError error) {
                Log.i(TAG,"Banner error onAdViewFailed"+error.getMessage());
            }

            @Override
            public void onAdViewClicked(UNADBannerView tradPlusView) {
                Log.i(TAG,"Banner onAdViewClicked");
            }
        });
```

## 6、加载横幅

```java
bannerContainer.loadAd();
```

## 7、释放资源

```java
  if(null!=bannerContainer){
            bannerContainer.destroy();
        }
```

## 8、注意事项

1、测试广告位ID UNAD_TEST_UNIT_ID   **应用上线时请替换为正式的广告位ID**

