## 一、简介

主要介绍在Android项目中如何集成 UNAD SDK的开屏广告：



## 二、代码集成

## 1、在自己的Application 中初始化SDK

UNAD_TEST_UNIT_ID为测试appid，上线请替换正式的APPID

```java
  String curProcessName = getProcessName(this);
        if (curProcessName != null && curProcessName.equalsIgnoreCase(this.getPackageName())) {
            //请填写您的APPID
            String unadAppid = "UNAD_TEST_UNIT_ID";
            // 主线程通过调用此方法初始化 SDK。
            UNAD.initialize(unadAppid, getApplicationContext(), new UNAD.InitCallback() {
                @Override
                public void onSuccess() {
                    Log.i(TAG, "onSuccess");
                }

                @Override
                public void onError(AdError error) {
                    Log.i(TAG, "error:" + error.getMessage());
                }

            });
        }
```

## 2、创建Activity设置为MAIN入口

```java
public class SplashActivity extends Activity 

 <activity
            android:name=".SplashActivity"
            android:label="@string/app_name"
            android:launchMode="singleTask"
            android:screenOrientation="portrait"
            android:windowSoftInputMode="stateHidden|stateAlwaysHidden"
            android:theme="@style/Theme.Testsdk.NoActionBar">
            <intent-filter>
                <action android:name="android.intent.action.MAIN" />
                <category android:name="android.intent.category.LAUNCHER" />
            </intent-filter>
        </activity>
```





## 3、创建开屏对象

***测试广告位ID UNAD_TEST_UNIT_ID   应用上线时请替换为正式的广告位ID***

```java
  UNADSplash unadSplash = new UNADSplash(this.getApplication());
```



## 4、设置广告ID和属性

```java
        unadSplash.setSkipButtonType(UNADSplash.SKIPTYPE.CLICK);
        unadSplash.setAdUnitId("UNAD_TEST_UNIT_ID");
        unadSplash.setBackgroundPicture(R.drawable.launchbg);
        //applogo
        unadSplash.setLogoPicture(R.drawable.logo_img);
        unadSplash.setDurationTime(10);
        //间隔多久一次广告
        unadSplash.setIntervals(1800);
        //超时时间 秒
        unadSplash.setTimeoutTime(8);
        //app名称
        unadSplash.setAppName("");
                
     
```

## 5、设置监听器

```java
 unadSplash.setAdViewListener(new UNADSplash.AdViewListener() {
            @Override
            public void onAdLoaded() {
                Log.e("UNAD_SDK", "onAdViewLoaded splash");
            }

            @Override
            public void onAdFailed(AdError error) {
                startMain();
                
            }

            @Override
            public void onAdClose() {
                startMain();
            }
            
            @Override
            public void onAdOpen() {
               
            }

            @Override
            public void onAdClicked() {

            }
        });
```

## 6、加载并打开广告

```java
    unadSplash.loadAd(SplashActivity.this);
```

## 7、onPause和onResume事件监听

**详细请参考DEMO**

```java
    public boolean canJump = false;
       
       
    protected void onPause() {
        super.onPause();
        canJump = false;
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (canJump) {
	    //打开开屏后的主activity
            startMain();
        }
        canJump = true;
    }
    
    
   public void startMain() {
        if (canJump) {
            //.这里开始执行打开主activity
	    startActivity......
        } else {
            canJump = true;
        }

    }

    
```

## 8、注意事项

1、测试广告位ID UNAD_TEST_UNIT_ID   **应用上线时请替换为正式的广告位ID**























