# 接入指南

# 概述

> 本页主要介绍工程配置注册事项

## 1.Gradle依赖

在App 的 build.gradle 文件中加入对应的依赖

```java

    implementation 'io.github.adgocompany:unad_global:2.6.8.2' 
      
    implementation 'androidx.appcompat:appcompat:1.1.0'
    implementation 'androidx.constraintlayout:constraintlayout:1.1.3'
    implementation 'androidx.navigation:navigation-fragment:2.2.2'
    implementation 'androidx.navigation:navigation-ui:2.2.2'
    androidTestImplementation 'androidx.test.ext:junit:1.1.1'
    androidTestImplementation 'androidx.test.espresso:espresso-core:3.2.0'
    implementation 'androidx.lifecycle:lifecycle-process:2.2.0'
    implementation 'com.google.android.material:material:1.2.1'
    implementation 'com.google.code.gson:gson:2.8.1'
    implementation 'com.squareup.okhttp3:okhttp:3.10.0'
    implementation 'com.github.bumptech.glide:glide:4.8.0'
    implementation 'androidx.recyclerview:recyclerview:1.1.0'      
         
         
         
```

如果无法下载请参考下面配置

```
repositories {
    google()
    jcenter()
    maven {
        url  "https://dl-maven-android.mintegral.com/repository/mbridge_android_sdk_oversea"
    }
    maven {
        url 'https://android-sdk.is.com/'
    }
    maven {
        url 'https://artifact.bytedance.com/repository/pangle/'
    }
    maven {
            url "https://s01.oss.sonatype.org/content/repositories/releases/"
        }
}


allprojects {
    repositories {
        google()
        jcenter()
        maven {
            url  "https://dl-maven-android.mintegral.com/repository/mbridge_android_sdk_oversea"
        }
        maven {
            url 'https://android-sdk.is.com/'
        }
        maven {
            url 'https://artifact.bytedance.com/repository/pangle/'
        }

    }
}
```

##  

## 2. 初始化SDK

注意：在 Application 的  `onCreate` 方法中调用初始化方法,传入UNAD的  appid（参考DEMO）

测试adgo-app-8379418688 应用上线时请替换为正式的APP ID

```java
 
	  String curProcessName = getProcessName(this);
        if (curProcessName != null && curProcessName.equalsIgnoreCase(this.getPackageName())) {
            //请填写您的APPID
            String unadAppid = "adgo-app-8379418688";
            // 主线程通过调用此方法初始化 SDK。
            UNAD.initialize(unadAppid, getApplicationContext(), new UNAD.InitCallback() {
                @Override
                public void onSuccess() {
                    Log.i(TAG, "onSuccess");
                }

                @Override
                public void onError(AdError error) {
                    Log.i(TAG, "error:" + error.getMessage());
                }

            });
        }


```





## 3. 修改AndroidManifest.xml文件, 添加必要权限

### 添加访问权限

在AndroidManifest.xml文件中添加

SDK不强制校验下列权限（即:无下面权限sdk也可正常工作），但建议开发者申请下面权限，尤其是READ_PHONE_STATE权限
READ_PHONE_STATE权限用于允许SDK获取用户标识

```xml
    <uses-permission android:name="android.permission.INTERNET" />
    <uses-permission android:name="android.permission.READ_PHONE_STATE" />
    <uses-permission android:name="android.permission.ACCESS_COARSE_LOCATION" />
    <uses-permission android:name="android.permission.WRITE_EXTERNAL_STORAGE"/>
    <uses-permission android:name="android.permission.READ_EXTERNAL_STORAGE"/>
    //需添加
	<uses-permission android:name="android.permission.WAKE_LOCK" />
   //google adid 需添加
	 <uses-permission android:name="com.google.android.gms.permission.AD_ID"/>





   application下配置如下，其中applicationId为您的包名
        <activity
            android:name="com.ironsource.sdk.controller.ControllerActivity"
            android:configChanges="orientation|screenSize"
            android:hardwareAccelerated="true" />

        <activity
            android:name="com.ironsource.sdk.controller.OpenUrlActivity"
            android:configChanges="orientation|screenSize"
            android:hardwareAccelerated="true"
            android:theme="@android:style/Theme.Translucent" />
        <provider
            android:authorities="${applicationId}.IronsourceLifecycleProvider"
            android:name="com.ironsource.lifecycle.IronsourceLifecycleProvider" />


```

### 添加APPLICATION_ID 配置

在AndroidManifest.xml文件的application节点下添加

```xml
  配置google所需要的appid
<meta-data
            android:name="com.google.android.gms.ads.APPLICATION_ID"
            android:value="ca-app-pub-3940256099942544~3347511713"/>
key
 <meta-data
            android:name="applovin.sdk.key"
            android:value="wfF4UGRbFrkIyf_QaZ4__2uqlp8u6bw07FpTU11IKKTomQTTgZJ3xv8y_T2NuZhel6otTSW9lehHq9MT1tddBR" />

```

```
compileOptions {
    sourceCompatibility JavaVersion.VERSION_11
    targetCompatibility JavaVersion.VERSION_11
}
```

## 4. 混淆



```
-keep class com.unad.sdk.** {*;}
-dontwarn com.google.ads.**
-keep public class com.google.android.gms.** { public protected *; }

# For old ads classes
-keep public class com.google.ads.**{
   public *;
}
# For mediation
-keepattributes *Annotation*

-keep class * extends java.util.ListResourceBundle {
   protected Object[][] getContents();
}
-keep public class com.google.android.gms.common.internal.safeparcel.SafeParcelable {
   public static final *** NULL;
}
-keepnames @com.google.android.gms.common.annotation.KeepName class *
-keepclassmembernames class * {
   @com.google.android.gms.common.annotation.KeepName *;
}

-keepnames class * implements android.os.Parcelable {
   public static final ** CREATOR;
}

-keep class com.aliyun.sls.android.producer.* { *; }
-keep interface com.aliyun.sls.android.producer.* { *; }

-keepclassmembers class com.mopub.** { public *; }
-keep public class com.mopub.**
-keep public class android.webkit.JavascriptInterface {}
-keep class * extends com.mopub.mobileads.BaseAd {}
-keep class * extends com.mopub.nativeads.CustomEventNative {}
# Keep methods that are accessed via reflection
-keepclassmembers class ** { @com.mopub.common.util.ReflectionTarget *; }
# Support for Android Advertiser ID.
-keep class com.google.android.gms.common.GooglePlayServicesUtil {*;}
-keep class com.google.android.gms.ads.identifier.AdvertisingIdClient {*;}
-keep class com.google.android.gms.ads.identifier.AdvertisingIdClient$Info {*;}
# Support for Google Play Services
# http://developer.android.com/google/play-services/setup.html
-keep class * extends java.util.ListResourceBundle {
    protected Object[][] getContents();
}
-keep public class com.google.android.gms.common.internal.safeparcel.SafeParcelable {
    public static final *** NULL;
}
-keepnames @com.google.android.gms.common.annotation.KeepName class *
-keepclassmembernames class * {
    @com.google.android.gms.common.annotation.KeepName *;
}
-keepnames class * implements android.os.Parcelable {
    public static final ** CREATOR;
}
-keep class androidx.media2.player.AudioFocusHandler {*;}
-keepnames class androidx.media2.player.MediaPlayer {*;}

-keepattributes Signature   
-keepattributes *Annotation*   
-keep class com.mbridge.** {*; }  
-keep interface com.mbridge.** {*; }  
-keep interface androidx.** { *; }
-keep class androidx.** { *; }
-keep public class * extends androidx.** { *; }
-dontwarn com.mbridge.**   
-keep class **.R$* { public static final int mbridge*; }

-keep public interface com.bytedance.sdk.openadsdk.downloadnew.** {*;}
-keep class com.bytedance.sdk.** { *; }
-keep class com.pgl.sys.ces.* {*;}
-keep class sg.bigo.** { *; }
-keepclassmembers class com.ironsource.sdk.controller.IronSourceWebView$JSInterface {
    public *;
}
-keepclassmembers class * implements android.os.Parcelable {
    public static final android.os.Parcelable$Creator *;
}

-keep class com.ironsource.adapters.** { *;
}
-dontwarn com.ironsource.mediationsdk.**
-dontwarn com.ironsource.adapters.**
-keepattributes JavascriptInterface
-keepclassmembers class * {
    @android.webkit.JavascriptInterface <methods>;
}

-keep class ms.bd.o.Pgl.**{*;}
-keep class com.bytedance.mobsec.metasec.ov.**{*;}
# Vungle
-dontwarn com.vungle.warren.downloader.DownloadRequestMediator$Status
-dontwarn com.vungle.warren.error.VungleError$ErrorCode

# Google
-keep class com.google.android.gms.** { *; }
-dontwarn com.google.android.gms.**

# GSON
-keepattributes *Annotation*
-keepattributes Signature
# Prevent R8 from leaving Data object members always null
-keepclassmembers,allowobfuscation class * {
  @com.google.gson.annotations.SerializedName <fields>;
}

# OkHttp + Okio
-dontwarn javax.annotation.**
-keepnames class okhttp3.internal.publicsuffix.PublicSuffixDatabase
-dontwarn org.codehaus.mojo.animal_sniffer.*
-dontwarn okhttp3.internal.platform.ConscryptPlatform

#amazon
-keep class com.amazon.** { *; }
-keep public class com.google.android.gms.ads.** {
    public *;
}
```




## 5.用户隐私政策(可选)

### GDPR

此部分旨在遵守欧盟的 [General Data Protection Regulation (GDPR)](https://gdpr.eu/)。

### CCPA

此部分旨在遵守 [California Consumer Privacy Act (CCPA)](https://oag.ca.gov/privacy/ccpa).

 需要设置GDPR1允许0不允许，CCPA 1允许0不允许,coppa  0adult, 1child 使用初始化使用下面构造方法

```java
 initialize(String appID, Context context, InitCallback initCallback,int GDPR,int CCPA,int coppa,int appLogo) 

```





注意：请开发者务必按照上面信息进行注册声明，详情见Demo。

支持最小android版本21

1、视频广告需要开启硬件加速**android:hardwareAccelerated="true"**

2、增加对http的支持: android:usesCleartextTraffic="true"



## 6.欧盟地区用户意见征求政策（必须)

 [欧盟地区用户意见征求政策](/Android-HW/ump.html)





