package com.unad.test;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.unad.samples.R;
import com.unad.sdk.UNADSplash;
import com.unad.sdk.dto.AdError;


public class SplashActivity extends Activity {
    public boolean canJump = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.splash);
        //还原
        BaseApplication baseApplication = (BaseApplication) getApplication();
        baseApplication.setRun(false);
        loadAd();


    }

    public void loadAd() {

        UNADSplash unadSplash = new UNADSplash(this.getApplication());
        unadSplash.setSkipButtonType(UNADSplash.SKIPTYPE.CLICK);
        unadSplash.setAdUnitId("UNAD_TEST_UNIT_ID");
        unadSplash.setAdViewListener(new UNADSplash.AdViewListener() {
            @Override
            public void onAdLoaded() {
                canJump=true;
                Log.e("UNAD_SDK", "UI  :onAdViewLoaded");
            }

            @Override
            public void onAdFailed(AdError error) {
                Log.e("UNAD_SDK", "UI  :onAdViewFailed" + error.getMessage());
                startMain();

            }

            @Override
            public void onAdClose() {
                Log.e("UNAD_SDK", "UI  :onAdViewClose");
                startMain();
            }

            @Override
            public void onAdOpen() {
                Log.e("UNAD_SDK", "UI  :onAdOpen");
            }

            @Override
            public void onAdClicked() {

            }
        });


        unadSplash.setLogoPicture(R.mipmap.ic_launcher);
        unadSplash.setDurationTime(5);
         unadSplash.setAppName(getString(R.string.app_name));
        //间隔多少一次广告 S
        unadSplash.setIntervals(1800);
        //最长超时时间S
        unadSplash.setTimeoutTime(8);
        unadSplash.loadAd(SplashActivity.this);


    }

    @Override
    protected void onPause() {
        super.onPause();
        canJump = false;
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (canJump) {
            startMain();
        }
        canJump = true;
    }


    public void startMain() {
        if (canJump) {
            //注意，这里请判断是否已经打开主页，打开了就不需要再打开主页了，不然下次广告会再次打开主页
            BaseApplication baseApplication = (BaseApplication) getApplication();
            if (!baseApplication.isRun) {
                startActivity(new Intent(SplashActivity.this, MainActivity.class));
                SplashActivity.this.finish();
                baseApplication.setRun(true);
            }
        } else {
            canJump = true;
        }

    }


}