package com.unad.test;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import com.unad.samples.R;
import com.unad.sdk.UNADRewarded;
import com.unad.sdk.dto.AdError;


public class RewardedActivity extends Activity {
    UNADRewarded UNADRewarded=null;
    private  String   TAG="RewardedActivity";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.rewarded);
        UNADRewarded= new UNADRewarded(RewardedActivity.this);
        UNADRewarded.setAdUnitId("UNAD_TEST_UNIT_ID");
        findViewById(R.id.loadRewardedAD).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                UNADRewarded.setAdViewListener(new UNADRewarded.AdViewListener() {
                    @Override
                    public void onAdLoaded() {
                        Log.e("UNAD_SDK","onAdLoaded");
                        Toast.makeText(
                                RewardedActivity.this, "ad loaded" , Toast.LENGTH_SHORT)
                                .show();
                    }


                    @Override
                    public void onAdFailed(AdError error) {
                        Log.e("UNAD_SDK","onAdFailed:"+error.getMessage());
                        Toast.makeText(
                                RewardedActivity.this, "ad error:"+ error.getMessage(), Toast.LENGTH_SHORT)
                                .show();
                    }

                    @Override
                    public void onAdClose() {

                        Toast.makeText(
                                RewardedActivity.this, "ad close" , Toast.LENGTH_SHORT)
                                .show();
                    }

                    @Override
                    public void onAdOpen() {

                    }

                    @Override
                    public void onAdClicked() {

                    }



                    @Override
                    public void onUserEarnedReward() {
                        Log.e("UNAD_SDK","onUserEarnedReward");
                        Toast.makeText(
                                RewardedActivity.this, "ad UserEarnedReward" , Toast.LENGTH_SHORT)
                                .show();
                    }
                });
                UNADRewarded.loadAd();

            }
        });
        findViewById(R.id.openRewarded).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(null!=UNADRewarded&&UNADRewarded.isLoaded()){
                    UNADRewarded.show(RewardedActivity.this);
                }else{
                    Toast.makeText(
                            RewardedActivity.this, "Ad is not ready" , Toast.LENGTH_SHORT)
                            .show();
                }

            }
        });
    }
    public  void back(View view){
        finish();
    }

}