package com.unad.test;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import androidx.annotation.Nullable;

import com.google.android.ump.ConsentForm;
import com.google.android.ump.FormError;
import com.unad.samples.R;


public class MainActivity extends Activity {
    private Button openUMP;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        openUMP=this.findViewById(R.id.openUMP);
        loadAndShowConsentFormIfRequired();
    }

    /**
     * 欧盟地区需要强制调用此方法用于用户授权，否则不会有google广告
     */
    private void loadAndShowConsentFormIfRequired(){
        GoogleMobileAdsConsentManager manage=  GoogleMobileAdsConsentManager.getInstance(this);
        //添加模拟测试设备ID和模拟欧盟用户经纬度 请参考gatherConsent中方法
        manage.gatherConsent(this,new GoogleMobileAdsConsentManager.OnConsentGatheringCompleteListener(){

            @Override
            public void consentGatheringComplete(FormError error) {

                if(manage.canRequestAds()){
                    Log.e("UNAD_SDK","通过");
                }
                //建议在设置中增加这项，让授权后的用户可再次更改选择
                if(manage.isPrivacyOptionsRequired()){
                    openUMP.setVisibility(View.VISIBLE);
                }else{
                    openUMP.setVisibility(View.GONE);
                }
                if(null!=error){
                    Log.i("UNAD_SDK","consentGatheringComplete:"+error.getMessage());
                }
            }
        });



    }
    public void showPrivacyOptionsFormBtn(View view) {
       // 意见征求表单要求允许用户随时修改其同意声明。请按照以下步骤实现隐私设置选项按钮。
       // 注意，这个选项是在已经弹出过征求表单窗口后的设备才显示，可根据方法isPrivacyOptionsRequired判断是否显示按钮
        GoogleMobileAdsConsentManager.getInstance(this).showPrivacyOptionsForm(this,new ConsentForm.OnConsentFormDismissedListener(){
            @Override
            public void onConsentFormDismissed(@Nullable FormError formError) {
                if(null!=formError){
                    Log.i("UNAD_SDK","onConsentFormDismissed:"+formError.getMessage());
                }

            }
        });
    }

    public void openBanner(View view) {
        startActivity(new Intent(this, BannerActivity.class));
    }

    public void openInterstitial(View view) {
        startActivity(new Intent(this, InterstitialActivity.class));
    }

    public void openRewarded(View view) {
        startActivity(new Intent(this, RewardedActivity.class));
    }

    public void openSplash(View view) {
        Toast.makeText(this,"开屏广告参考SplashActivity",Toast.LENGTH_LONG).show();
    }

    public void openFeed(View view) {
        startActivity(new Intent(this, FeedRecyclerViewActivity.class));
    }

    public void openFeedDemo(View view) {
        startActivity(new Intent(this, FeedActivity.class));
    }


    public void testAl(View view) {

    }


}