package com.unad.test;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RatingBar;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.ads.MuteThisAdListener;
import com.google.android.gms.ads.MuteThisAdReason;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.unad.samples.R;
import com.unad.sdk.UNADFeedAd;
import com.unad.sdk.UNADFeedAdView;
import com.unad.sdk.dto.AdError;

import java.util.ArrayList;
import java.util.List;


public class FeedActivity extends Activity {
    private String TAG = "UNAD_SDK";
    private UNADFeedAd mADManager;
    private List<UNADFeedAdView> mAdViewList = new ArrayList<>();
    private LinearLayout adlayout;

    private boolean isCustomizeBoolean = true;
    //是否自定义admob关闭
    private boolean admobRequestCustomMuteThisAdBoolean=true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.feed);
        adlayout = this.findViewById(R.id.adlayout);
        init();

    }

    private void init() {
        mADManager = new UNADFeedAd(this, "UNAD_TEST_UNIT_ID", new UNADFeedAd.AdViewListener() {

            @Override
            public void onAdLoaded(UNADFeedAdView unadFeedAdView) {
                mAdViewList.add(unadFeedAdView);
                //ad添加到布局中
                adlayout.addView(unadFeedAdView);
                //渲染
                unadFeedAdView.render();



                ///如要需要自定义信息流样式，可以修改以下代码，对部分广告源有效
//                if (isCustomizeBoolean && unadFeedAdView.getAdmobNative() != null) {
//                    NativeAdView adView = (NativeAdView) LayoutInflater.from(FeedActivity.this).inflate(R.layout.native_ad_unified, null);
//                    populateNativeAdView(unadFeedAdView.getAdmobNative(), adView);
//                    unadFeedAdView.render(adView);
//                } else {
//                    unadFeedAdView.render();
//                }
//


            }


            @Override
            public void onAdFailed(AdError error) {
                Log.e(TAG, "onAdViewFailed.....msg:" + error.getMessage());

            }

            @Override
            public void onAdClicked(UNADFeedAdView unadFeedAdView) {

            }

            @Override
            public void onAdClose(UNADFeedAdView unadFeedAdView) {
                Toast.makeText(FeedActivity.this,"关闭",Toast.LENGTH_LONG).show();
                //移除布局
                adlayout.removeView(unadFeedAdView);
            }

            @Override
            public void onAdOpen(UNADFeedAdView unadFeedAdView) {

            }
        });
        ///如要需要自定义信息流样式，可以修改以下代码，对部分广告源有效
       // mADManager.setAdmobTemplate(isCustomizeBoolean);
      //  mADManager.setAdmobRequestCustomMuteThisAd(admobRequestCustomMuteThisAdBoolean);

    }

    public void startAd(View view) {
        Log.e(TAG, "start load ad......");
        mADManager.loadAd();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mADManager != null) {
            mADManager.onResume();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mADManager != null) {
            mADManager.onPause();
        }
    }


    @Override
    protected void onDestroy() {
        // 使用完了每一个UNADFeedAdView之后都要释放掉资源。
        if (mAdViewList != null) {
            for (UNADFeedAdView view : mAdViewList) {
                view.destroy();
            }
        }
        if (null != mADManager) {
            mADManager.release();
        }
        super.onDestroy();


    }


    public void back(View view) {
        finish();

    }

    /**
     * 设置关闭事件
     * @param nativeAd
     * @param view
     * @param reasonList
     */
    private void setAdCloseClickListener(NativeAd nativeAd,View view,List<MuteThisAdReason> reasonList){
        if(reasonList==null||reasonList.size()==0){
            view.setVisibility(View.GONE);
            return;
        }
        String [] array= new String[reasonList.size()] ;
        for(int i=0;i<reasonList.size();i++){
            array[i]=reasonList.get(i).getDescription()+"";
        }

        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                new AlertDialog.Builder(FeedActivity.this)
                        .setTitle("reason")
                        .setItems(array, new DialogInterface.OnClickListener (){

                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {
                                //这里做删除或者不展示广告的操作


                                //告知原因
                                nativeAd.muteThisAd(reasonList.get(i));

                            }
                        })
                        .show();
            }
        });


    }


    private void populateNativeAdView(NativeAd nativeAd, NativeAdView adView) {
        //判断是否可以自定义关闭，如果不可以则不能关闭
        if (isCustomizeBoolean&&admobRequestCustomMuteThisAdBoolean&&nativeAd.isCustomMuteThisAdEnabled()) {
            adView.findViewById(R.id.ad_close).setVisibility(View.VISIBLE);
            Toast.makeText(FeedActivity.this,"自定义关闭按钮  ‘显示’",Toast.LENGTH_SHORT).show();
            //设置关闭事件
            setAdCloseClickListener(nativeAd,adView.findViewById(R.id.ad_close),nativeAd.getMuteThisAdReasons());
            nativeAd.setMuteThisAdListener(new MuteThisAdListener() {
                @Override
                public void onAdMuted() {
                    Toast.makeText(FeedActivity.this, "关闭", Toast.LENGTH_SHORT).show();
//这里需要移除广告布局

                }
            });
        } else {
            //不可以自定义
            Toast.makeText(FeedActivity.this,"自定义关闭按钮  ‘不显示’",Toast.LENGTH_SHORT).show();
           adView.findViewById(R.id.ad_close).setVisibility(View.GONE);

        }

        // Set the media view.
        adView.setMediaView((MediaView) adView.findViewById(R.id.ad_media));
        // Set other ad assets.
        adView.setHeadlineView(adView.findViewById(R.id.ad_headline));
        adView.setBodyView(adView.findViewById(R.id.ad_body));

        adView.setCallToActionView(adView.findViewById(R.id.ad_call_to_action));

        adView.setIconView(adView.findViewById(R.id.ad_app_icon));
        

        adView.setPriceView(adView.findViewById(R.id.ad_price));
        adView.setStarRatingView(adView.findViewById(R.id.ad_stars));
        adView.setStoreView(adView.findViewById(R.id.ad_store));
        adView.setAdvertiserView(adView.findViewById(R.id.ad_advertiser));

        // The headline and mediaContent are guaranteed to be in every NativeAd.
        ((TextView) adView.getHeadlineView()).setText(nativeAd.getHeadline());
        adView.getMediaView().setMediaContent(nativeAd.getMediaContent());

        // These assets aren't guaranteed to be in every NativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(View.INVISIBLE);
        } else {
            adView.getBodyView().setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        if (nativeAd.getCallToAction() == null) {
            adView.getCallToActionView().setVisibility(View.INVISIBLE);
        } else {
            adView.getCallToActionView().setVisibility(View.VISIBLE);
            ((Button) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        }

        if (nativeAd.getIcon() == null) {
            adView.getIconView().setVisibility(View.GONE);
        } else {
            ((ImageView) adView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getPrice() == null) {
            adView.getPriceView().setVisibility(View.INVISIBLE);
        } else {
            adView.getPriceView().setVisibility(View.VISIBLE);
            ((TextView) adView.getPriceView()).setText(nativeAd.getPrice());
        }

        if (nativeAd.getStore() == null) {
            adView.getStoreView().setVisibility(View.INVISIBLE);
        } else {
            adView.getStoreView().setVisibility(View.VISIBLE);
            ((TextView) adView.getStoreView()).setText(nativeAd.getStore());
        }

        if (nativeAd.getStarRating() == null) {
            adView.getStarRatingView().setVisibility(View.INVISIBLE);
        } else {
            ((RatingBar) adView.getStarRatingView()).setRating(nativeAd.getStarRating().floatValue());
            adView.getStarRatingView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getAdvertiser() == null) {
            adView.getAdvertiserView().setVisibility(View.INVISIBLE);
        } else {
            ((TextView) adView.getAdvertiserView()).setText(nativeAd.getAdvertiser());
            adView.getAdvertiserView().setVisibility(View.VISIBLE);
        }

        // This method tells the Google Mobile Ads SDK that you have finished populating your
        // native ad view with this native ad.
        adView.setNativeAd(nativeAd);

        // Get the video controller for the ad. One will always be provided, even if the ad doesn't
        // have a video asset.
        VideoController vc = nativeAd.getMediaContent().getVideoController();

        // Updates the UI to say whether or not this ad has a video asset.
        if (vc.hasVideoContent()) {

            // Create a new VideoLifecycleCallbacks object and pass it to the VideoController. The
            // VideoController will call methods on this object when events occur in the video
            // lifecycle.
            vc.setVideoLifecycleCallbacks(new VideoController.VideoLifecycleCallbacks() {
                @Override
                public void onVideoEnd() {

                    super.onVideoEnd();
                }
            });
        } else {
            // videoStatus.setText("Video status: Ad does not contain a video asset.");
            //   refresh.setEnabled(true);
        }
    }
}