package com.unad.test;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.Build;
import android.util.Log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.Thread.UncaughtExceptionHandler;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;


public class EstarAppliectionErrorHandler  implements UncaughtExceptionHandler{
	   public  final String tag = "UNAD_SDK";

	   // CrashHandler 实例  
	   private static EstarAppliectionErrorHandler INSTANCE = new EstarAppliectionErrorHandler();  

	   // 程序�?Context 对象  
	   private Context mContext;  

	   // 系统默认�?UncaughtException 处理�? 
	   private UncaughtExceptionHandler mDefaultHandler;

	   // 用来存储设备信息和异常信�? 
	   private Map<String, String> infos = new HashMap<String, String>();  



	   /** 保证只有�?�� CrashHandler 实例 */  
	   private EstarAppliectionErrorHandler() {  
	   }  

	   /** 获取 CrashHandler 实例 ,单例模式 */  
	   public static EstarAppliectionErrorHandler getInstance() {  
	       return INSTANCE;  
	   }  

	   /** 
	    * 初始�?
	    * 
	    * @param context 
	    */  
	   public void init(Context context) {  
	       mContext = context;  
	     
	       // 获取系统默认�?UncaughtException 处理�? 
	       mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();  
	     
	       // 设置�?CrashHandler 为程序的默认处理�? 
	       Thread.setDefaultUncaughtExceptionHandler(this);  
	   }  

	   /** 
	    * �?UncaughtException 发生时会转入该函数来处理 
	    */  
	     
	   public void uncaughtException(Thread thread, Throwable ex) {  
		   //保存错误日志
		   handleException(ex);
		
	     //  if (!handleException(ex) && mDefaultHandler != null) {  
	           // 如果用户没有处理则让系统默认的异常处理器来处�? 
	         //  mDefaultHandler.uncaughtException(thread, ex);  

			System.exit(0); 
//	       } else {  
//	           try {  
//	               Thread.sleep(3000);  
//	           } catch (InterruptedException e) {  
//	               Log.e(TAG, "error : ", e);  
//	           }  
//
//	           // �?��程序  
//	           android.os.Process.killProcess(android.os.Process.myPid());  
//	           System.exit(1);  
//	       }  
	   }  

	   /** 
	    * 自定义错误处理，收集错误信息，发送错误报告等操作均在此完�?
	    *  
	      * @param ex 
	      * @return true：如果处理了该异常信息；否则返回 false 
	      */  
	     private boolean handleException(Throwable ex) {  
	         if (ex == null) {  
	             return false;  
	         }  
	         
//	         // 使用 Toast 来显示异常信�? 
//	         new Thread() {  
//	             @Override  
//	             public void run() {  
//	                 Looper.prepare();  
//	                 Toast.makeText(mContext, "很抱歉，程序出现异常，即将�?出�?", Toast.LENGTH_LONG).show();  
//	                 Looper.loop();  
//	             }  
//	         }.start();  
//	   
	         // 收集设备参数信息  
	         collectDeviceInfo(mContext);  
	         // 保存日志文件  
	         saveCrashInfo2File(ex);  
	         return true;  
	     }  
	   
	     /** 
	      * 收集设备参数信息 
	      * @param ctx 
	      */  
	     public void collectDeviceInfo(Context ctx) {  
	         try {  
	             PackageManager pm = ctx.getPackageManager();  
	             PackageInfo pi = pm.getPackageInfo(ctx.getPackageName(), PackageManager.GET_ACTIVITIES);  
	   
	             if (pi != null) {  
	                 String versionName = pi.versionName == null ? "null" : pi.versionName;  
	                 String versionCode = pi.versionCode + "";  
	                 infos.put("versionName", versionName);  
	                 infos.put("versionCode", versionCode);  
	             }  
	         
	   
	         Field[] fields = Build.class.getDeclaredFields();  
	         for (Field field : fields) {  
	             try {  
	                 field.setAccessible(true);  
	                 infos.put(field.getName(), field.get(null).toString());  
	                 Log.d(tag, field.getName() + " ADGO系统级: " + field.get(null));
	             } catch (Exception e) {  
	                 Log.e(tag, "ADGO系统级an error occured when collect crash info", e);
	             }  
	         }  
	         } catch (NameNotFoundException e) {  
	             Log.e(tag, "ADGO系统级 an error occured when collect package info", e);
	         } 
	     }  
	   
	     /** 
	      * 保存错误信息到文件中 
	     * 
	      * @param ex 
	      * @return  返回文件名称,便于将文件传送到服务�?
	      */  
	     private String saveCrashInfo2File(Throwable ex) {  
	         StringBuffer sb = new StringBuffer();  
	         for (Map.Entry<String, String> entry : infos.entrySet()) {  
	             String key = entry.getKey();  
	             String value = entry.getValue();  
	             sb.append(key + "=" + value + "\n");  
	         }  
	   
	         Writer writer = new StringWriter();  
	         PrintWriter printWriter = new PrintWriter(writer);  
	         ex.printStackTrace(printWriter);  
	         Throwable cause = ex.getCause();  
	         while (cause != null) {  
	             cause.printStackTrace(printWriter);  
	             cause = cause.getCause();  
	         }  
	         printWriter.close();  
	   
	         String result = writer.toString();  
	         sb.append(result);  
	         Log.e(tag, "ADGO系统级别异常ApplicationExceptio"+sb.toString());

	         return null;  
	     }  
	 }  


