package com.unad.test;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.WebView;

import com.unad.samples.R;
import com.unad.sdk.UNAD;
import com.unad.sdk.dto.AdError;

public class BaseApplication extends Application {
    private final String TAG = "UNAD_SDK";
    public  boolean isRun=false;

    public  void setRun(boolean isRun){
        this.isRun=isRun;
    }
    public void onCreate() {

        super.onCreate();
        // 未知异常捕获类初始化:
//        EstarAppliectionErrorHandler crashHandler = EstarAppliectionErrorHandler.getInstance();
//        crashHandler.init(getApplicationContext());

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
            String processName = getProcessName(this);
            String packageName = this.getPackageName();
            if (!packageName.equals(processName)) {
                WebView.setDataDirectorySuffix(processName);
            }
        }



        String curProcessName = getProcessName(this);
        if (curProcessName != null && curProcessName.equalsIgnoreCase(this.getPackageName())) {
            //请填写您的APPID
            String unadAppid = "adgo-app-8379418688";

            // 主线程通过调用此方法初始化 SDK。
            UNAD.initialize(unadAppid, getApplicationContext(), new UNAD.InitCallback() {
                @Override
                public void onSuccess() {
                    Log.i(TAG, "ADGO初始化成功");
                }

                @Override
                public void onError(AdError error) {
                    Log.i(TAG, "初始化ADGO广告==error:" + error.getMessage());
                }

            }, R.mipmap.ic_launcher);


        }




    }

    private String getProcessName(Context context) {
        if (context == null) return null;
        ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
            if (processInfo.pid == android.os.Process.myPid()) {
                return processInfo.processName;
            }
        }
        return null;
    }


}
