package com.unad.test;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

import com.unad.samples.R;
import com.unad.sdk.UNADBannerView;
import com.unad.sdk.dto.AdError;


public class BannerActivity extends Activity {
    private UNADBannerView bannerContainer;
    private  String   TAG="UNAD_SDK";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.banner);

        bannerContainer = findViewById(R.id.ad_banner_view);
        bannerContainer.setAdUnitId("UNAD_TEST_UNIT_ID");
        bannerContainer.setAdViewListener(new UNADBannerView.AdViewListener(){
            @Override
            public void onAdLoaded(UNADBannerView tradPlusView) {
                Log.i(TAG,"Banner onAdViewLoaded");
            }

            @Override
            public void onAdFailed(UNADBannerView tradPlusView, AdError error) {
                Log.i(TAG,"Banner error onAdViewFailed"+error.getMessage());
            }

            @Override
            public void onAdClicked(UNADBannerView tradPlusView) {
                Log.i(TAG,"Banner onAdViewClicked");
            }

            @Override
            public void onAdClose(UNADBannerView unadBannerView) {

            }

            @Override
            public void onAdOpen(UNADBannerView unadBannerView) {
                Log.i(TAG,"Banner onAdOpen");
            }
        });
        bannerContainer.setWidth(PxUtils.dpToPx(this,320));

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if(null!=bannerContainer){
            bannerContainer.destroy();
        }
    }
    public  void back(View view){
        finish();
    }

    public void showbanner(View view){
        bannerContainer.loadAd();
    }
}